/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file item_waiting_for_players.hpp
 * \brief This item is activated when all players are colliding with it.
 * \author Julien Jorge
 */
#ifndef __PTB_ITEM_WAITING_FOR_PLAYERS_HPP__
#define __PTB_ITEM_WAITING_FOR_PLAYERS_HPP__

#include "ptb/item/plee/plee.hpp"

namespace ptb
{
  /**
   * \brief This item is activated when all players are colliding with it.
   * \author Julien Jorge
   */
  template<class Base>
  class item_waiting_for_players:
    public Base
  {
  public:
    item_waiting_for_players();

    void progress( bear::universe::time_type elapsed_time );

  protected:
    virtual void on_one_player( plee* p );
    virtual void on_all_players( plee* p1, plee* p2 );

  private:
    void collision
    ( bear::engine::base_item& that, bear::universe::collision_info& info );

  private:
    /** \brief The first player, if colliding with this item. */
    plee* m_first_player;

    /** \brief The second player, if colliding with this item. */
    plee* m_second_player;

  }; // class item_waiting_for_players
} // namespace ptb

#include "ptb/item_brick/impl/item_waiting_for_players.tpp"

#endif // __PTB_ITEM_WAITING_FOR_PLAYERS_HPP__
