/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bitmap_font_loader.hpp
 * \brief This class loads a bitmap font.
 * \author Julien Jorge
 */
#ifndef __ENGINE_BITMAP_FONT_LOADER_HPP__
#define __ENGINE_BITMAP_FONT_LOADER_HPP__

#include "visual/font.hpp"

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    class level_globals;

    /**
     * \brief This class loads a bitmap font.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT bitmap_font_loader
    {
    public:
      bitmap_font_loader( std::istream& f, level_globals& glob );

      visual::font run();

    private:
      /** \brief The file from which we load the font. */
      std::istream& m_file;

      /** \brief The level_globals in which we load the resources. */
      level_globals& m_level_globals;

    }; // class bitmap_font_loader
  } // namespace engine
} // namespace bear

#endif // __ENGINE_BITMAP_FONT_LOADER_HPP__
