/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file binary_linear_expression.hpp
 * \brief A logical and of two linear expressions.
 * \author Julien Jorge
 */
#ifndef __EXPR_BINARY_LINEAR_EXPRESSION_HPP__
#define __EXPR_BINARY_LINEAR_EXPRESSION_HPP__

#include "expr/base_linear_expression.hpp"
#include "expr/linear_expression.hpp"

#include <functional>

namespace bear
{
  namespace expr
  {
    /**
     * \brief A linear expression with two operands.
     * \author Julien Jorge
     */
    template<typename F>
    class binary_linear_expression:
      public base_linear_expression
    {
    public:
      /** \brief The type of the operands. */
      typedef linear_expression operand_type;

    public:
      binary_linear_expression();
      binary_linear_expression(const binary_linear_expression<F>& that);
      binary_linear_expression
      ( const linear_expression& left, const linear_expression& right );

      const linear_expression& get_left_operand() const;
      void set_left_operand( const linear_expression& op );

      const linear_expression& get_right_operand() const;
      void set_right_operand( const linear_expression& op );

      base_linear_expression* clone() const;
      double evaluate() const;

    private:
      /** \brief The left operand. */
      linear_expression m_left;

      /** \brief The right operand. */
      linear_expression m_right;

    }; // class binary_linear_expression

    typedef binary_linear_expression< std::plus<double> > linear_plus;
    typedef binary_linear_expression< std::minus<double> > linear_minus;
    typedef
    binary_linear_expression< std::multiplies<double> > linear_multiplies;
    typedef binary_linear_expression< std::divides<double> > linear_divides;

  } // namespace expr
} // namespace bear

#include "expr/impl/binary_linear_expression.tpp"

#endif // __EXPR_BINARY_LINEAR_EXPRESSION_HPP__
