/*
    Bear Engine - Model editor

    Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/xml/model_file.hpp
 * \brief A class for reading source model files.
 * \author Julien Jorge
 */
#ifndef __BF_MODEL_FILE_HPP__
#define __BF_MODEL_FILE_HPP__

#include <iostream>
#include <wx/xml/xml.h>

namespace bf
{
  class gui_model;

  namespace xml
  {
    /**
     * \brief A class for reading source model files.
     * \author Julien Jorge
     */
    class model_file
    {
    public:
      gui_model* load( const wxString& file_path ) const;
      void save( const gui_model& mdl, std::ostream& os ) const;

    private:
      gui_model* load_model( const wxXmlNode* node ) const;

    }; // class model_file
  } // namespace xml
} // namespace bf

#endif // __BF_MODEL_FILE_HPP__
