;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../../../common.scm")

(define idling
  (lambda (dest_image)
    ; the ratio of the size is 0.25

    (let ( (src_name "idle.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (right_arm 0)
               (cap 1)
               (head 2)
               (tooth 3)
               (right_leg 4)
               (body 5)
               (left_arm 6)
               (left_leg 7) )

          (create-layer src_image
                        (list right_arm cap head tooth right_leg body left_arm
                              left_leg)
                        0 0 26 32 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define idling

(define walking
  (lambda (dest_image)
    ; the ratio of the size is 0.25

    (let ( (src_name "walk.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (right_leg_1 0)
               (right_leg_3 1)
               (right_leg_4 2)
               (right_arm_1 3)
               (right_arm_3 4)
               (right_arm_4 5)
               (head_1 6)
               (ear_1 7)
               (ear_3 8)
               (ear_4 9)
               (body_1 10)
               (body_3 11)
               (body_4 12)
	       )

          (create-layer src_image
                        (list head_1 right_leg_1 right_arm_1 ear_1 body_1)
                        26 0 46 22 dest_image)
          (create-layer src_image
                        (list head_1 right_leg_3 right_arm_3 ear_3 body_3)
                        72 0 46 22 dest_image)
          (create-layer src_image
                        (list head_1 right_leg_4 right_arm_4 ear_4 body_4)
                        118 0 46 22 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define walking

(define digging
  (lambda (dest_image)
    ; the ratio of the size is 0.25

    (let ( (src_name "dig.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (foot_5_1 0)
               (foot_5_2 1)
               (body_1 2)
               (body_2 3)
               (body_3 4)
               (body_4 5)
               (body_5 6)
	       )

          (create-layer src_image
                        (list body_1)
                        164 0 29 28 dest_image)
          (create-layer src_image
                        (list body_2)
                        193 0 29 28 dest_image)
          (create-layer src_image
                        (list body_3)
                        222 0 29 28 dest_image)
          (create-layer src_image
                        (list body_4)
                        0 32 29 28 dest_image)
          (create-layer src_image
                        (list body_5 foot_5_1)
                        29 32 29 28 dest_image)
          (create-layer src_image
                        (list body_5 foot_5_2)
                        58 32 29 28 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define digging

(define dust
  (lambda (dest_image)
    ; the ratio of the size is 0.25

    (let ( (src_name "dust.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (dust_1 0)
               (dust_2 1)
               (dust_3 2)
               (dust_4 3)
	       )

          (create-layer src_image
                        (list dust_1)
                        87 22 32 16 dest_image)
          (create-layer src_image
                        (list dust_2)
                        119 22 32 16 dest_image)
          (create-layer src_image
                        (list dust_3)
                        87 38 32 16 dest_image)
          (create-layer src_image
                        (list dust_4)
                        119 38 32 16 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define dust

(define dust-end
  (lambda (dest_image)
    ; the ratio of the size is 0.25

    (let ( (src_name "dust-end.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (dust_end_1 0)
               (dust_end_2 1)
               (dust_end_3 2)
               (dust_end_4 3)
	       )

          (create-layer src_image
                        (list dust_end_1)
                        151 32 19 15 dest_image)
          (create-layer src_image
                        (list dust_end_2)
                        170 32 19 15 dest_image)
          (create-layer src_image
                        (list dust_end_3)
                        151 48 19 15 dest_image)
          (create-layer src_image
                        (list dust_end_4)
                        170 48 19 15 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define dust-end

(define jumping
  (lambda (dest_image)
    ; the ratio of the size is 0.25

    (let ( (src_name "jump.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (body_1 0)
               (body_2 1)
               (body_3 2)
               (body_4 3)
	       )

          (create-layer src_image
                        (list body_1)
                        189 32 40 40 dest_image)
          (create-layer src_image
                        (list body_2)
                        0 61 40 40 dest_image)
          (create-layer src_image
                        (list body_3)
                        40 61 40 40 dest_image)
          (create-layer src_image
                        (list body_4)
                        80 61 40 40 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define jumping

(define falling
  (lambda (dest_image)
    ; the ratio of the size is 0.25

    (let ( (src_name "fall.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (right_leg 0)
               (right_arm 1)
               (head 2)
               (right_ear 3)
	       (body 4)
	       (left_ear 5)
	       (left_arm 6)
	       (left_leg 7)
	       )

          (create-layer src_image
                        (list right_leg right_arm head right_ear body left_ear
			      left_arm left_leg)
                        120 61 23 35 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define falling

(define injured
  (lambda (dest_image)
    ; the ratio of the size is 0.25

    (let ( (src_name "injured.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (right_leg 0)
               (right_arm 1)
	       (eye 2)
               (head 3)
               (right_ear 4)
	       (body 5)
	       (left_leg 6)
	       (left_ear 7)
	       )

          (create-layer src_image
                        (list right_leg right_arm eye head right_ear body
			      left_leg left_ear)
                        143 61 21 35 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define injured

(let ( (dest_name "rabbit-1.png") )
  (let ( (dest_image (car (gimp-image-new 256 128 RGB))) )
    (let ( (bk (car (gimp-layer-new dest_image 256 128 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (idling dest_image)
    (walking dest_image)
    (digging dest_image)
    (dust dest_image)
    (dust-end dest_image)
    (jumping dest_image)
    (falling dest_image)
    (injured dest_image)

    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
