;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../../../common.scm")

(define pecking
  (lambda (dest_image)
    ; the ratio of the size is 0.125 (0.125739640 vert., 0.125 hor.)

    (let ( (src_name "pecking.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (wing_4 3)
               (wing_3 4)
               (wing_2 5)
               (wing_1 6)
               (leg    7)
               (merged_body_4  8)
               (merged_body_3  9)
               (merged_body_2 10)
               (merged_body_1 11)
               (leg_back 14) )

          (create-layer src_image
                        (list leg leg_back wing_1 merged_body_1)
                        0 0 43 85 dest_image)
          (create-layer src_image
                        (list leg leg_back wing_2 merged_body_2)
                        43 0 43 85 dest_image)
          (create-layer src_image
                        (list leg leg_back wing_3 merged_body_3)
                        86 0 43 85 dest_image)
          (create-layer src_image
                        (list leg leg_back wing_4 merged_body_4)
                        129 0 43 85 dest_image)

          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define pecking

(define watching
  (lambda (dest_image)
    (let ( (src_name "watching.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (sunglasses 0)
               (hair 1)
               (beak 2)
               (wing 3)
               (leg 4)
               (body 5)
               (leg_back 6) )

          (create-layer src_image
                        (list sunglasses hair beak wing leg body leg_back)
                        172 0 40 81 dest_image)
          ) ; let
        ) ; let
      ) ; let

    (let ( (src_name "watching-right.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (sunglasses 0)
               (hair 1)
               (beak 2)
               (wing 3)
               (leg 4)
               (body 5)
               (leg_back 6) )

          (create-layer src_image
                        (list sunglasses hair beak wing leg body leg_back)
                        212 0 37 80 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define watching

(define attacking
  (lambda (dest_image)
    (let ( (src_name "attacking.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (merged  0)
               (speed_3 1)
               (speed_2 2)
               (speed_1 3) )

          (create-layer src_image
                        (list merged speed_1)
                        0 85 107 37 dest_image)
          (create-layer src_image
                        (list merged speed_1 speed_2)
                        107 85 107 37 dest_image)
          (create-layer src_image
                        (list merged speed_1 speed_2 speed_3)
                        0 122 107 37 dest_image)
          (create-layer src_image
                        (list merged speed_2 speed_3)
                        107 122 107 37 dest_image)
          (create-layer src_image
                        (list merged speed_3)
                        0 159 107 37 dest_image)
          (create-layer src_image
                        (list merged)
                        107 159 107 37 dest_image)

          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define attacking

(define wig
  (lambda (dest_image)
    (let ( (src_name "wig.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (main 0) )

          (create-layer src_image
                        (list main)
                        0 196 26 17 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define wig

(define feather
  (lambda (dest_image)
    (let ( (src_name "feather.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (green 0)
               (red 1)
               (main 2) )

          (create-layer src_image
                        (list main)
                        26 196 24 7 dest_image)
          (create-layer src_image
                        (list main red)
                        50 196 24 7 dest_image)
          (create-layer src_image
                        (list main green)
                        74 196 24 7 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define feather

(define hole
  (lambda (dest_image)
    (let ( (src_name "hole.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (main 0) )

          (create-layer src_image
                        (list main)
                        98 196 2 4 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define hole

(define flying
  (lambda (dest_image)
    (let ( (src_name "flying.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (sunglasses  0)
               (hair 1)
               (beak 2)
               (eyes 3)
               (right_wing_1 4)
               (right_wing_2 5)
               (right_wing_3 6)
               (right_wing_4 7)
               (right_leg 8)
               (body 9)
               (left_leg 10)
               (left_wing_1 11)
               (left_wing_2 12)
               (left_wing_3 13)
               (left_wing_4 14) )

          (create-layer src_image
                        (list sunglasses hair beak eyes body right_leg left_leg
                              right_wing_1 left_wing_1)
                        214 80 96 80 dest_image)
          (create-layer src_image
                        (list sunglasses hair beak eyes body right_leg left_leg
                              right_wing_2 left_wing_2)
                        214 160 96 80 dest_image)
          (create-layer src_image
                        (list sunglasses hair beak eyes body right_leg left_leg
                              right_wing_3 left_wing_3)
                        310 0 96 80 dest_image)
          (create-layer src_image
                        (list sunglasses hair beak eyes body right_leg left_leg
                              right_wing_4 left_wing_4)
                        406 0 96 80 dest_image)

          ; and dying too
          (create-layer src_image
                        (list beak eyes body right_leg left_leg
                              right_wing_1 left_wing_4)
                        310 80 96 80 dest_image)
          (create-layer src_image
                        (list beak eyes body right_leg left_leg
                              right_wing_2 left_wing_3)
                        406 80 96 80 dest_image)
          (create-layer src_image
                        (list beak eyes body right_leg left_leg
                              right_wing_3 left_wing_2)
                        310 160 96 80 dest_image)
          (create-layer src_image
                        (list beak eyes body right_leg left_leg
                              right_wing_4 left_wing_1)
                        406 160 96 80 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define flying

(let ( (dest_name "woodpecker-1.png") )
  (let ( (dest_image (car (gimp-image-new 512 256 RGB))) )
    (let ( (bk (car (gimp-layer-new dest_image 512 256 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (pecking dest_image);
    (watching dest_image);
    (feather dest_image);
    (hole dest_image);
    (attacking dest_image);
    (flying dest_image)
    (wig dest_image)

    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
