;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../../common.scm")

(define owl-waiting
  (lambda (dest_image)

    (let ( (src_name "owl-waiting.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (noise  1)
               (eye_r  2)
               (eye_l  3)
               (beak_2 4)
               (beak_1 5)
               (beak_0 6)
               (body   7)
               (foot   8) )

          (create-layer src_image 
                        (list noise eye_r eye_l beak_0 body foot)
                        0 0 62 85 dest_image)
          (create-layer src_image 
                        (list noise eye_r eye_l beak_1 body foot)
                        62 0 62 85 dest_image)
          (create-layer src_image 
                        (list noise eye_r eye_l beak_2 body foot)
                        124 0 62 85 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define owl-waiting

(define owl-with-nut
  (lambda (dest_image)

    (let ( (src_name "owl-with-nut.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (noise       1)
               (eye         2)
               (body        3)
               (feet        4)
               (nut_shadows 5)
               (nut         6) )
          
          (create-layer src_image 
                        (list noise eye body feet nut_shadows nut)
                        186 0 70 85 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define owl-with-nut

(define owl-tears
  (lambda (dest_image)

    (let ( (src_name "owl-tears.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (noise  0)
               (beak   1)
               (tears  2)
               (body   3)
               (wing_4 4)
               (wing_3 5)
               (wing_2 6)
               (wing_1 7)
               (wing_0 8) )
          
          (create-layer src_image
                        (list noise beak tears body wing_0)
                        0 85 72 85 dest_image)
          (create-layer src_image
                        (list noise beak tears body wing_1)
                        72 85 72 85 dest_image)
          (create-layer src_image
                        (list noise beak tears body wing_2)
                        144 85 72 85 dest_image)
          (create-layer src_image
                        (list noise beak tears body wing_3)
                        0 170 72 85 dest_image)
          (create-layer src_image
                        (list noise beak tears body wing_4)
                        72 170 72 85 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define owl-tears

(define nut
  (lambda (dest_image)

    (let ( (src_name "nut.xcf.bz2") )
      (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
             )

        ; layer names
        (let ( (noise   0)
               (shadows 1)
               (nut     2) )
          
          (create-layer src_image 
                        (list noise shadows nut)
                        216 85 24 24 dest_image)
          ) ; let
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define nut

(let ( (dest_name "owl.png") )
  (let ( (dest_image (car (gimp-image-new 256 256 RGB))) )
    (let ( (bk (car (gimp-layer-new dest_image 256 256 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (owl-waiting dest_image);
    (owl-with-nut dest_image);
    (owl-tears dest_image);
    (nut dest_image)

    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
