/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file authorize_action_toggle.cpp
 * \brief Implementation of the ptb::authorize_action_toggle class.
 * \author Sbastien Angibaud
 */
#include "ptb/item/authorize_action_toggle.hpp"

#include "universe/derived_item_handle.hpp"
#include "ptb/player.hpp"
#include "ptb/util.hpp"

BASE_ITEM_EXPORT( authorize_action_toggle, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::authorize_action_toggle::authorize_action_toggle()
  : m_value(0), m_action(player_action::action_null)
{

} // authorize_action_toggle::authorize_action_toggle()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the value of a field of type string
 * \param name The name of the field.
 * \param value The value of the field.
 */
bool ptb::authorize_action_toggle::set_string_field
( const std::string& name, const std::string& value)
{
  bool result(true);

  if ( name == "authorize_action_toggle.action" )
    {
      m_action = player_action::from_string(value);
      result = ( m_action != player_action::action_null );
    }
  else
    result = super::set_string_field(name, value);

  return result;
} // authorize_action_toggle::set_string_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the value of a field of type bool
 * \param name The name of the field.
 * \param value The value of the field.
 */
bool ptb::authorize_action_toggle::set_bool_field
( const std::string& name, bool value)
{
  bool result(true);

  if ( name == "authorize_action_toggle.value" )
    m_value = value;
  else
    result = super::set_bool_field(name, value);

  return result;
} // authorize_action_toggle::set_bool_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Actions done when the state of the toggle changes from off to on.
 * \param activator The item that changed the state.
 */
void ptb::authorize_action_toggle::on_toggle_on
(bear::engine::base_item *activator)
{
  if ( m_action != player_action::action_null )
    {
      player* player = util::find_player( get_level_globals(), 1 );

      if ( player != NULL )
        player->set_autorized_action(m_action,m_value);

      player = util::find_player( get_level_globals(), 2 );

      if ( player != NULL )
        player->set_autorized_action(m_action,m_value);
    }
} // authorize_action_toggle::on_toggle_on()

