/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file level_settings.cpp
 * \brief Implementation of the ptb::level_settings class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/level_settings.hpp"
#include "ptb/level_variables.hpp"

BASE_ITEM_EXPORT( level_settings, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 */
ptb::level_settings::level_settings()
{
} // level_settings::level_settings()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialize the item.
 */
void ptb::level_settings::build()
{
  super::build();
  kill();
} // level_settings::build()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c bool.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool
ptb::level_settings::set_bool_field( const std::string& name, bool value )
{
  bool result = true;

  if (name == "level_settings.hazelnut")
    level_variables::set_hazelnut(get_level(), value);
  else if (name == "level_settings.friendly_fire")
    level_variables::set_friendly_fire(get_level(), value);
  else
    result = super::set_bool_field(name,value);

  return result;
} // level_settings::set_bool_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c real.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool
ptb::level_settings::set_real_field( const std::string& name, double value )
{
  bool result = true;

  if (name == "level_settings.time_record")
    level_variables::set_time_record(get_level(), value);
  else
    result = super::set_real_field(name,value);

  return result;
} // level_settings::set_real_field()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type \c real.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 */
bool
ptb::level_settings::set_u_integer_field
( const std::string& name, unsigned int value )
{
  bool result = true;

  if (name == "level_settings.honeypots_found")
    level_variables::set_honeypots_found(get_level(), value);
  else
    result = super::set_u_integer_field(name,value);

  return result;
} // level_settings::set_u_integer_field()
