/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file throwable_items_container.cpp
 * \brief Implementation of the ptb::throwable_items_container class.
 * \author Sebastien Angibaud
 */
#include "ptb/throwable_item/throwable_items_container.hpp"

#include "ptb/throwable_item/hazelnut_throwable_item.hpp"
#include "ptb/throwable_item/honeypot_throwable_item.hpp"
#include "ptb/throwable_item/stone_throwable_item.hpp"
#include "ptb/player.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 * \param p The pointer on the player.
 */
ptb::throwable_items_container::throwable_items_container(player* p)
  : m_current_throwable_item(throwable_item::stone_throwable_item_type)
{
  m_throwable_items.resize(throwable_item::s_throwable_items_cardinality);

  m_throwable_items[throwable_item::stone_throwable_item_type] =
    new stone_throwable_item(p);
  m_throwable_items[throwable_item::air_honeypot_throwable_item_type] =
    new honeypot_throwable_item
    (p, throwable_item::air_honeypot_throwable_item_type);
  m_throwable_items[throwable_item::fire_honeypot_throwable_item_type] =
    new honeypot_throwable_item
    (p, throwable_item::fire_honeypot_throwable_item_type);
  m_throwable_items[throwable_item::water_honeypot_throwable_item_type] =
    new honeypot_throwable_item
    (p, throwable_item::water_honeypot_throwable_item_type);
  m_throwable_items[throwable_item::hazelnut_throwable_item_type] =
    new hazelnut_throwable_item(p);
} // throwable_items_container::throwable_items_container()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
ptb::throwable_items_container::~throwable_items_container()
{
  for (unsigned int i=0; i!=throwable_item::s_throwable_items_cardinality; ++i)
    delete m_throwable_items[i];
} // throwable_items_container::~throwable_items_container()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell if there exists an throwable_item after the current one.
 */
bool ptb::throwable_items_container::has_next() const
{
  bool result = false;

  unsigned int next = m_current_throwable_item;

  next += 1;
  if ( next == throwable_item::s_throwable_items_cardinality )
    next = 0;

  for ( ; !result && (next != m_current_throwable_item); )
    {
      if ( m_throwable_items[next]->appears() )
        result = true;

      next += 1;
      if ( next == throwable_item::s_throwable_items_cardinality )
        next = 0;
    }

  return result;
} // throwable_items_container::has_next();

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell if there exists an throwable_item after the current one.
 */
bool ptb::throwable_items_container::has_previous() const
{
  bool result = true;

  return result;
} // throwable_items_container::has_previous();

/*----------------------------------------------------------------------------*/
/**
 * \brief Select the next throwable_item.
 */
void ptb::throwable_items_container::next()
{
  unsigned int next = m_current_throwable_item;
  next += 1;

  if ( next == throwable_item::s_throwable_items_cardinality )
     next = 0;

  for ( ; !m_throwable_items[next]->appears(); )
    {
      next += 1;
      if ( next == throwable_item::s_throwable_items_cardinality )
        next = 0;
    }

  m_current_throwable_item = next;
} // throwable_items_container::next();

/*----------------------------------------------------------------------------*/
/**
 * \brief Select the previous throwable_item.
 */
void ptb::throwable_items_container::previous()
{
} // throwable_items_container::previous();

/*----------------------------------------------------------------------------*/
/**
 * \brief Control if the current throwable_item can be dropped.
 */
void ptb::throwable_items_container::control_current_throwable_item()
{
  if ( !m_throwable_items[m_current_throwable_item]->appears() )
    next();
} // throwable_items_container::control_current_throwable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Select a given throwable_item.
 */
void ptb::throwable_items_container::select
(throwable_item::throwable_item_type t)
{
  if ( m_throwable_items[t]->appears() )
    m_current_throwable_item = t;
}
// throwable_items_container::select();

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the selected throwable_item.
 */
ptb::throwable_item*
ptb::throwable_items_container::get_current_throwable_item()
{
  return m_throwable_items[m_current_throwable_item];
} // throwable_items_container::get_current_throwable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the selected throwable_item.
 */
const ptb::throwable_item*
ptb::throwable_items_container::get_current_throwable_item() const
{
  return m_throwable_items[m_current_throwable_item];
} // throwable_items_container::get_current_throwable_item()
