/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  flag-nexus.c:  virtualized x86 eflags handling
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#define IN_NEXUS_SPACE
#include "monitor.h"

/* Note: Used by both host/monitor spaces */
  void
write_eflags(vm_t *vm, Bit32u raw, Bit32u change_mask)
{
  Bit32u change_virtualized_mask, change_unvirtualized_mask;
  Bit32u prevIF;

  prevIF = vm->guest_cpu.veflags.fields.if_;

  /* Modify the guest eflags, by changing only those bits specified */
  /* in change_mask. */

  /* Set virtualized eflags fields in guest_cpu.veflags */
  change_virtualized_mask = change_mask & VirtualizedEflags;
  vm->guest_cpu.veflags.raw =
    (vm->guest_cpu.veflags.raw & ~change_virtualized_mask) |
    (raw & change_virtualized_mask);

  /* Set unvirtualized eflags fields in the guest_context->eflags */
  change_unvirtualized_mask = change_mask & ~VirtualizedEflags;
  vm->addr->guest_context->eflags.raw =
    (vm->addr->guest_context->eflags.raw & ~change_unvirtualized_mask) |
    (raw & change_unvirtualized_mask);

  if (vm->addr->guest_context->eflags.raw & FLG_TF)
    vm->guest_cpu.async_event = 1;
  if (!prevIF && vm->guest_cpu.veflags.fields.if_) {
    /* Transition from IF==0 to 1. */
    vm->guest_cpu.async_event = 1;
    }
}

/* Note: Used by both host/monitor spaces */
  Bit32u
read_eflags(vm_t *vm)
{
  Bit32u eflags;
  eflags =
    (vm->guest_cpu.veflags.raw & VirtualizedEflags) |
    (vm->addr->guest_context->eflags.raw & ~VirtualizedEflags);
  return(eflags);
}
