/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  iodev.h:  IO devices, typedefs, defines, etc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */



/* Define the IO callback types. */
typedef Bit32u (*ioReadHandler_t)(void *, Bit32u, unsigned);
typedef void   (*ioWriteHandler_t)(void *, Bit32u, Bit32u, unsigned);


#define MaxIOHandlers    20  /* Must be within 8 bits. */
#define NoIOHandlerID  0xff  /* No handler manages this IO port. */
#define UnmappedIOSeen 0xfe  /* Access to this unhandled IO port has
                              * been seen, tag with this value so we
                              * only report accesses once.
                              */

typedef struct {
  Bit8u  readHandlerID[64 * 1024 + 1];
  struct {
    void           *thisPtr; /* C++ handlers need this. */
    ioReadHandler_t callback;
    unsigned        space;
    } read[MaxIOHandlers];
  unsigned readHandlerCount;

  Bit8u  writeHandlerID[64 * 1024 + 1];
  struct {
    void            *thisPtr; /* C++ handler need this. */
    ioWriteHandler_t callback;
    unsigned         space;
    } write[MaxIOHandlers];
  unsigned writeHandlerCount;

  } ioHandlers_t;
