/************************************************************************
 * $Id: ports.c,v 1.2 2002/07/21 23:14:55 DemonLord Exp $
 ************************************************************************
 *
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 2002  Kevin P. Lawton
 *
 *  ports.c: Provides a description of known IO ports.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

/*
 *  Somebody with a lot of spare time should make more detailled descriptions.
 *
 *  Eric Laberge <e.laberge@videotron.ca>
 */

#include <stdio.h>
#include "iosniffer.h"

static char dummy[] = "";

static char keyboard[] = "Keyboard";
static char video[] = "Video";
static char floppy[] = "Floppy";
static char hd[] = "IDE";
static char cmos[] = "CMOS";
static char dma[] = "DMA";
static char ps2[] = "PS/2";
static char serial[] = "Serial port";

static char p86echo[] = "Plex86 Console Echo";

static char *getKeyboardString (int port, int iswrite)
{
  if (port == 0x60 || port == 0x64)
    return keyboard;

  return NULL;
}

static char *getVideoString (int port, int iswrite)
{
  if (port < 0x3B4 || port > 0x3DC)
    return NULL;

  switch (port)
  {
  case 0x3B4:
  case 0x3B5:
  case 0x3B8:
  case 0x3BA:
  case 0x3BF:
  case 0x3C0:
  case 0x3C1:
  case 0x3C2:
  case 0x3C3:
  case 0x3C4:
  case 0x3C5:
  case 0x3C6:
  case 0x3C7:
  case 0x3C8:
  case 0x3C9:
  case 0x3CA:
  case 0x3CB:
  case 0x3CC:
  case 0x3CD:
  case 0x3CE:
  case 0x3CF:
  case 0x3D4:
  case 0x3D5:
  case 0x3D8:
  case 0x3D9:
  case 0x3DA:
  case 0x3DB:
  case 0x3DC:
    return video;
  default:
    return NULL;
  }
}

static char *getFloppyString(int port, int iswrite)
{
  if (port >= 0x3F0 && port <= 0x3F7)
    return floppy;
  return NULL;
}

static char *getHDString(int port, int iswrite)
{
  if ((port >= 0x170 && port <= 0x177) || (port >= 0x1F0 && port <= 0x1F7) ||
      (port >= 0x168 && port <= 0x16E) || (port >= 0x1E8 && port <= 0x1EF) || 
      port == 0x276 || port == 0x277 || port == 0x2F6 || port == 0x2F7 ||
      port == 0x376 || port == 0x377 || port == 0x3F6 || port == 0x3F7)
    return hd;
  return NULL;
}

static char *getCMOSString(int port, int iswrite)
{
  if (port == 0x70 || port == 0x71)
    return cmos;
  return NULL;
}

static char *getDMAString(int port, int iswrite)
{
  if ((port >= 0x00 && port <= 0xF) || (port >= 0x81 && port <=0x8F) ||
      (port >= 0xC0 && port <= 0xDE)) 
    return dma;
  return NULL;
}

static char *getPS2String(int port, int iswrite)
{
  if (port == 0x92)
    return ps2;
  return NULL;
}

static char *getSerialString(int port, int iswrite)
{
  if ((port >= 0x2E8 && port <= 0x2EF) || (port >= 0x2F8 && port <= 0x2FF) ||
      (port >= 0x3E8 && port <= 0x3EF) || (port >= 0x3F8 && port <= 0x3FF))
    return serial;
  return NULL;
}

static char *getP86EchoString(int port, int iswrite)
{
  if (port == 0xFFF0 ||
      (port >= 0x400 && port <= 0x403) ||
      (port >= 0x500 && port <= 0x503))
    return p86echo;
  return NULL;
}

char *getString (int port, int iswrite)
{
  char *res;

  if ((res = getKeyboardString (port, iswrite)))
    return res;
  if ((res = getVideoString (port, iswrite)))
    return res;
  if ((res = getFloppyString(port, iswrite)))
    return res;
  if ((res = getHDString(port, iswrite)))
    return res;
  if ((res = getCMOSString(port, iswrite)))
    return res;
  if ((res = getDMAString(port, iswrite)))
    return res;
  if ((res = getPS2String(port, iswrite)))
    return res;
  if ((res = getSerialString(port, iswrite)))
    return res;
  
  if ((res = getP86EchoString(port, iswrite)))
    return res;
  
  return dummy;
}
