/************************************************************************
 * $Id: multiboot.h,v 1.2 2002/07/21 23:14:55 DemonLord Exp $
 ************************************************************************
 *
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The plex86 developers team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef MULTIBOOT_H
#define MULTIBOOT_H

/* Magic value identifying the multiboot_header */
#define MULTIBOOT_MAGIC		0x1badb002

/* Align all boot modules on page (4KB) boundaries.  */
#define MULTIBOOT_PAGE_ALIGN	0x00000001

/* magic value for eax */
#define MULTIBOOT_VALID         0x2badb002

#define MULTIBOOT_AOUT_KLUDGE	0x00010000

#define MULTIBOOT_MEMORY	(1L<<0)

struct multiboot_header
{
  /* Must be MULTIBOOT_MAGIC */
  Bit32u magic;

  /* Feature flags - see below.  */
  Bit32u flags;

  /* Checksum: magic + flags + checksum == 0 */
  Bit32u checksum;

  /* These are only valid if MULTIBOOT_AOUT_KLUDGE is set.  */
  Bit32u header_addr;
  Bit32u load_addr;
  Bit32u load_end_addr;
  Bit32u bss_end_addr;
  Bit32u entry;
};

struct multiboot_info
{
  /* These flags indicate which parts of the multiboot_info are valid;
     see below for the actual flag bit definitions.  */
  Bit32u flags;

  /* Lower/Upper memory installed in the machine.
     Valid only if MULTIBOOT_MEMORY is set in flags word above.  */
  Bit32u mem_lower;
  Bit32u mem_upper;

  /* BIOS disk device the kernel was loaded from.
     Valid only if MULTIBOOT_BOOT_DEVICE is set in flags word above.  */
  Bit8u boot_device[4];

  /* Command-line for the OS kernel: a null-terminated ASCII string.
     Valid only if MULTIBOOT_CMDLINE is set in flags word above.  */
  Bit32u cmdline;

  /* List of boot modules loaded with the kernel.
     Valid only if MULTIBOOT_MODS is set in flags word above.  */
  Bit32u mods_count;
  Bit32u mods_addr;

  /* Symbol information for a.out or ELF executables. */
  union
  {
    struct
    {
      /* a.out symbol information valid only if MULTIBOOT_AOUT_SYMS
	 is set in flags word above.  */
      Bit32u		tabsize;
      Bit32u		strsize;
      Bit32u		addr;
      unsigned		reserved;
    } a;

    struct
    {
      /* ELF section header information valid only if
	 MULTIBOOT_ELF_SHDR is set in flags word above.  */
      unsigned		num;
      Bit32u		size;
      Bit32u		addr;
      Bit32u		shndx;
    } e;
  } syms;

  /* Memory map buffer.
     Valid only if MULTIBOOT_MEM_MAP is set in flags word above.  */
  Bit32u		mmap_count;
  Bit32u		mmap_addr;
};

#endif
