/************************************************************************
 * $Id: io_thread.h,v 1.1 2002/08/13 00:06:25 DemonLord Exp $
 ************************************************************************
 *
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The plex86 developers team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef _IO_THREAD_H_
#define _IO_THREAD_H_

typedef void* (*eventAction)(void* data);

int thread_init (void);
void thread_fini (void);
void post_evt (int type, void* data, int data_size);
void set_io_handlers (eventAction *handler_vector);
void queue_flush (void);

#endif /* _IO_THREAD_H_ */
