/************************************************************************
 * $Id: resetmod.c,v 1.2 2002/07/21 23:14:55 DemonLord Exp $
 ************************************************************************
 *
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The plex86 developers team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>

#include "plex86.h"

int
main(void)
{
    int fileno, ret;
    int request, data;

    fileno = open("/dev/plex86", O_RDONLY);
    if (fileno < 0) {
        fprintf(stderr, "open returned error\n");
        exit(1);
    }
    fprintf(stderr, "open returned success\n");

    request = PLEX86_RESET; /* reset */
    data = 0;
    ret = ioctl(fileno, request, data);
    if (ret < 0) {
        fprintf(stderr, "ioctl returned error\n");
    } else {
        fprintf(stderr, "ioctl successful\n");
    }

    ret = close(fileno);
    if (ret < 0) {
        fprintf(stderr, "close returned error\n");
        exit(1);
    }
    fprintf(stderr, "close returned success\n");

    exit(0);
}
