

//////////////////////////////////////////////////////////////////
//                                                              //
//           PLINK (c) 2005-2008 Shaun Purcell                  //
//                                                              //
// This file is distributed under the GNU General Public        //
// License, Version 2.  Please see the file COPYING for more    //
// details                                                      //
//                                                              //
//////////////////////////////////////////////////////////////////


#ifndef __CNV_H__
#define __CNV_H__

class CNVIndivReport {
 public:

  CNVIndivReport() 
    {
      n = count = 0;
      segCount = 0;
      t1 = t2 = t3 = t4 = t5 = t6 = 0;
    }
  
  void calculateResults()
  {
    // Note -- T1, T2 and T5 are based on *all* individuals
    // For the length tests, the denominator is all individuals
    // with at least one event
    
    if ( count == 0 )
      count = 1;

    t1 /= n;
    t2 /= n;
    t3 /= count;
    t4 /= count;
    t5 /= n;    
    t6 /= n;
  }

  // Total number of individuals looked at
  int n;

  // Number of individuals with an event
  int count;

  // Number of segments in this group
  int segCount;
  
  // Test results
  // 1) # segs; 2) #inds w 1+; 3) total kb; 4) mean seg kb, 5) gene-count, 
  // 6) gene-count-1+
  
  double t1;
  double t2;
  double t3;
  double t4;
  double t5;
  double t6;
};



#endif
