

//////////////////////////////////////////////////////////////////
//                                                              //
//           PLINK (c) 2005-2008 Shaun Purcell                  //
//                                                              //
// This file is distributed under the GNU General Public        //
// License, Version 2.  Please see the file COPYING for more    //
// details                                                      //
//                                                              //
//////////////////////////////////////////////////////////////////


#include <iostream>
#include <sstream>

#include "plink.h"
#include "helper.h"
#include "options.h"
#include "sockets.h"

using namespace std;

#define  PORT_NUM    8222
#define  IP_ADDR    "155.52.206.11"

void Plink::lookup()
{

#ifdef SKIP
  printLOG("Web-lookup not implemented on this system...\n");
  return;
#else

  printLOG("PLINK-SNP (WGAS SNP annotation courtesy of Patrick Sullivan)\n");

  vector<string> tokens;
  vector<string> genelist;
  
  if ( par::lookup_gene )
    {
      if ( par::lookup_multiple_genes ) 
	{
	  
 	  string query = "";
 	  int c = 0;
	  
 	  string window= int2str(par::lookup_snp_kb_window * 1000);
	  
 	  // Read list, append to query and send
 	  checkFileExists(par::lookup_gene_name);
 	  ifstream S(par::lookup_gene_name.c_str(),ios::in);
 	  while(!S.eof())
 	    {
 	      string gene;
 	      S >> gene;
 	      if (gene=="")
 		continue;
 	      query += "GENEWIN " + gene + " " + window + " ";
 	      c++;
	      genelist.push_back(gene);
 	      if ( c>100 ) 
 		error("Please do not send large batch queries to PLINK-SNP");
 	    }
 	  S.close();      
	  	  
 	  tokens = socketConnection( this , 
 				     IP_ADDR,
 				     PORT_NUM,
				     query );      
	}
      else
	{
	  string window = int2str( par::lookup_gene_kb_window * 1000 );
	  
	  printLOG("Looking up gene information (and SNPs +/- " 
		   + int2str(par::lookup_gene_kb_window)+" kb)\n");
	  
	  string cmd = "GENEWIN "+par::lookup_gene_name + " " + window;
	  
	  tokens = socketConnection( this , 
				     IP_ADDR,
				     PORT_NUM,
				     cmd );
	}
    }
  else if ( par::lookup_single_snp )
    {

      string window= int2str(par::lookup_snp_kb_window * 1000);

      printLOG("Looking up SNP information, listing genes within " 
	       + int2str(par::lookup_snp_kb_window)+" kb\n");

      string cmd = "SNPWIN "+par::lookup_snp + " " + window;

      tokens = socketConnection( this , 
				 IP_ADDR,
				 PORT_NUM,
				 cmd );      
    }
  else
    {
      string query = "";
      int c = 0;

      string window= int2str(par::lookup_snp_kb_window * 1000);

      // Read list, append to query and send
      checkFileExists(par::lookup_snp);
      ifstream S(par::lookup_snp.c_str(),ios::in);
      while(!S.eof())
	{
	  string snp;
	  S >> snp;
	  if (snp=="")
	    continue;
	  query += "SNPWIN " + snp + " " + window + " ";
	  c++;
	  if ( c>100 ) 
	    error("Please do not send large batch queries to PLINK-SNP");
	}
      S.close();      

      printLOG("Looking up SNP information, listing genes within " 
	       + int2str(par::lookup_snp_kb_window)+" kb)\n");

      tokens = socketConnection( this , 
				 IP_ADDR,
				 PORT_NUM,
				 query );      

    }
   
  
  if ( tokens.size() == 0 ) 
    return;


  if ( par::lookup_to_file )
    {
      
      ofstream OUT;
      string f = par::output_file_name;
      
      // Need to handle both single and multiple instances

      if ( par::lookup_gene ) 
	{

	  f += ".snp.list";
	  
	  if ( tokens[0] == "-1") 
	    {
	      printLOG("\n\nCould not find gene " 
		       + par::lookup_gene_name 
		       + " in database\n");
	      return;
	    }

	  printLOG("Writing SNP details to [ " + f + " ]\n\n\n");	  
	  OUT.open( f.c_str(), ios::out );

	  bool geneInfo = true;
	  int totalSNPs = 0;
	  int gcount = 0;

	  for (int i=1; i<tokens.size(); i++)
	    {
	      if (tokens[i]=="__END")
		{

		  // Skip following line return
		  ++i;
		  
		  if ( geneInfo )
		    
		    {
		      // Move from gene information to SNPs

		      if ( par::lookup_multiple_genes )
			OUT << genelist[gcount++] << "\n";

		      geneInfo = false;
		      continue;
		    }
		  else
		    {
		      // Move from SNPs to gene information
		      // Skip count 
		      ++i;
		      geneInfo = true;
		      printLOG("----------------------------------------------------------\n");
		      printLOG("\n\n");

		      if ( par::lookup_multiple_genes )
			OUT << "END\n\n";

		      continue;
		    }
		}
	      
	      if ( geneInfo ) 
		{
		  if (tokens[i]=="\\n")
		    printLOG("\n");
		  else if ( tokens[i]=="\\t")
		    printLOG("\t");
		  else
		    printLOG(tokens[i]+" ");	     
		}
	      else
		{
		  if (tokens[i]=="\\n")
		    OUT << "\n";
		  else if ( tokens[i]=="\\t")
		    OUT << "\t";
		  else
		    OUT << tokens[i] << " ";	  
		}

	    }
	  
	  OUT.close();
	 
	}
      else // multiple SNP queries selected
	{
	  
	  f += ".snp.annot";
	  
	  printLOG("\nWriting SNP details to [ " + f + " ]\n");
      
	  OUT.open( f.c_str(), ios::out );
	  for (int i=0; i<tokens.size(); i++)
	    {
	      if (tokens[i]=="\\n")
		OUT << "\n";
	      else if ( tokens[i]=="\\t")
		OUT << "\t";
	      else
		OUT << tokens[i] << " ";	  
	    }      
	  OUT.close();
	}
    }
  else // Standard to LOG (single SNP query)
    {
      printLOG("\n\n");
      for (int i=0; i<tokens.size(); i++)
	{
	  if (tokens[i]=="\\n")
	    printLOG("\n");
	  else if ( tokens[i]=="\\t")
	    printLOG("\t");
	  else
	    printLOG(tokens[i]+" ");
	}
    }

  return;

#endif

}

