


//////////////////////////////////////////////////////////////////
//                                                              //
//           PLINK (c) 2005-2008 Shaun Purcell                  //
//                                                              //
// This file is distributed under the GNU General Public        //
// License, Version 2.  Please see the file COPYING for more    //
// details                                                      //
//                                                              //
//////////////////////////////////////////////////////////////////


#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <stdio.h>


#include "plink.h"
#include "helper.h"

#ifdef WITH_LAPACK
#include "lapackf.h"

extern "C" int dgesdd_(char *jobz, int *m, int *n, double *a, 
		       int *lda, double *s, double *u, int *ldu, 
		       double *vt, int *ldvt, double *work, int *lwork, 
		       int *iwork, int *info);

#endif


 /*
   This file has my implementation of the LAPACK routine dgesdd for
   C++.  This program solves for the singular value decomposition of a
   rectangular matrix A.  The function call is of the form

     void dgesdd(double **A, int m, int n, double *S, double *U, double *VT)

     A: the m by n matrix that we are decomposing
     m: the number of rows in A
     n: the number of columns in A (generally, n<m)
     S: a min(m,n) element array to hold the singular values of A
     U: a [m, min(m,n)] element rectangular array to hold the right
        singular vectors of A.  These vectors will be the columns of U,
        so that U[i][j] is the ith element of vector j.
     VT: a [min(m,n), n] element rectangular array to hold the left
         singular vectors of A.  These vectors will be the rows of VT
 	(it is a transpose of the vector matrix), so that VT[i][j] is
 	the jth element of vector i.

   Note that S, U, and VT must be initialized before calling this
   routine, or there will be an error.  Here is a quick sample piece of
   code to perform this initialization; in many cases, it can be lifted
   right from here into your program.

     S = new double[minmn];
     U = new double*[m]; for (int i=0; i<m; i++) U[i] = new double[minmn];
     VT = new double*[minmn]; for (int i=0; i<minmn; i++) VT[i] = new double[n];

   Scot Shaw
   24 January 2000 */




bool svd_lapack(fmatrix_t & A, floatvec_t & S, fmatrix_t & U, fmatrix_t & V)
{

  cout << "Using LAPACK SVD library function...\n";
    
#ifdef WITH_LAPACK
    
    int m = A.size();
    int n = A.size();
    int info;

    double *pA, *pV, *pU, *pS;
    double *work;
    int *iwork;
    iwork = NULL;
    pA = (double *) malloc(sizeof(double) * m * n);
    pV = (double *) malloc(sizeof(double) * m * n);
    pU = (double *) malloc(sizeof(double) * m * n);
    pS = (double *) malloc(sizeof(double) * m);
    iwork = (int *) malloc(sizeof(int) * 8 * m);

    pA = map1D(A);

    double optim_lwork;
    int lwork;
    lwork = -1;
    

    dgesdd_("A", &m, &n, (double*) pA, &m, (double*) pS, (double*) pU, &m, (double*) pV, &n, &optim_lwork, &lwork, iwork, &info);
    lwork = (int) optim_lwork;
    work = (double *) malloc(sizeof(double) * lwork );

    dgesdd_("A", &m, &n, (double*) pA, &m, (double*) pS, (double*) pU, &m, (double*) pV, &n, work, &lwork, iwork, &info);
    delete iwork;
    delete work;

    fmatrix_t Vtmp;
    sizefMatrix(Vtmp,m,m);
    sizefMatrix(U,m,m);
    sizefMatrix(V,n,n);
    S.resize(m);

    map2D(pA, A);
    map2D(pU, U);
    map2D(pV, Vtmp);

     for( int i = 0; i < m; i++ )
	S[i] = pS[i];
    
    delete pS;

    // transpose Vt to get V
    for( int i = 0; i < m; i++ )
	for( int j = 0; j < n; j++ )
	    V[j][i] = Vtmp[i][j];
   
    
    //display(S);
    //display(U);
    //display(V);

    return true;
    
#else
    
    // LAPACK support not compiled 
    return false;
    
#endif
    
}


double* map1D(fmatrix_t & in)
{
    int rows = in.size();
    int cols = rows>0 ? in[0].size() : 0;    
    double * out = NULL;
    if ( rows == 0 || cols == 0) 
	return out;
    out = new double[rows*cols];  
    int i, j;  
    for (i=0; i<rows; i++) 
	for (j=0; j<cols; j++){ 
	    out[i+j*rows] = in[i][j];
	}
    
    return(out);
}

void map2D(double *in, fmatrix_t & out)
{
    int rows = out.size();
    int cols = rows>0 ? out[0].size() : 0;
    int i, j;
    for (i=0; i<rows; i++) 
	for (j=0; j<cols; j++) {
	    
	    out[i][j] = (float) in[i+j*rows];
	}
    
    delete in;
}
