#lang scheme/base

(require tests/eli-tester scribble/text/syntax-utils scheme/runtime-path)

(define-runtime-path text-dir "text")

(test

 ;; begin/collect scope etc
 (begin/collect 1) => 1
 (begin/collect 1 2 3) => '(1 2 3)
 (begin/collect) => '()
 (begin/collect (define x 1) x) => 1
 (begin/collect (define x 1)) => '()
 (begin/collect (define x 1) x x x) => '(1 1 1)
 (begin/collect (define x 1) (define y 2) x y x y) => '(1 2 1 2)
 (begin/collect (define x 1) x (define y 2) y) => '(1 2)
 (begin/collect (define x 1) x (define y 2)) => '(1)
 (begin/collect (define x 1) x x (define y 2) y y) => '(1 1 2 2)
 (begin/collect (define x 1) x (define x 2) x) => '(1 2)
 (begin/collect (define x 1) x x (define x 2) x x) => '(1 1 2 2)
 (begin/collect (define (x) y) (define y 1) (x) (x) (x)) => '(1 1 1)
 (begin/collect (define x 1) x (define y 2) x) => '(1 1)
 (begin/collect (define x 1) x x (define y 2) x x) => '(1 1 1 1)
 (begin/collect (define x 1) x x (define y x) y y) => '(1 1 1 1)
 (begin/collect (define (x) y) (define y 1) (x) (x)
                (define (x) y) (define y 2) (x) (x))
 => '(1 1 2 2)
 (begin/collect (define-syntax-rule (DEF x y) (define x y)) (DEF x 1) x x)
 => '(1 1)
 (begin/collect (define-syntax-rule (DEF x y) (define x y)) 1 (DEF x 2) x)
 => '(1 2)
 (begin/collect (define-syntax-rule (DEF x y) (define x y))
                (DEF x 1) x x
                (DEF x 2) x x)
 => '(1 1 2 2)
 (begin/collect (define (x) y)
                (define-syntax-rule (DEF x y) (define x y))
                (DEF y 1) (x) (x)
                (DEF y 2) (x) (x))
 => '(1 1 1 1)
 (let ([y 1]) (begin/collect y y (define x y) x y x)) => '(1 1 1 1 1)
 (let ([y 1]) (begin/collect y y (define y 2) y y)) => '(1 1 2 2)
 (let ([y 1]) (begin/collect (define (x) y) (x) (x))) => '(1 1)
 (let ([y 1]) (begin/collect (define (x) y) (define y 2) (x) (x))) => '(2 2)
 (let ([y 1]) (begin/collect (define (x) y) (x) (x) (define y 2) y y))
 => '(1 1 2 2)
 (let ([y 1]) (begin/collect (define (x) y) (x) (x) (define y 2) y y (x)))
 => '(1 1 2 2 1)
 (let ([y 1]) (begin/collect (define (x) y) (x) (x) (define y 2) (x) y y))
 => '(1 1 1 2 2)
 (begin/collect (begin (define (x) y)
                       (define-syntax-rule (DEF x y) (define x y))
                       (define y 2))
                (x) (x))
 => '(2 2)
 (begin/collect (define (x) y)
                (begin (define-syntax-rule (DEF x y) (define x y))
                       (define y 2))
                (x) (x))
 => '(2 2)
 (begin/collect (define (x) y)
                (define-syntax-rule (DEF x y) (define x y))
                (begin (define y 2))
                (x) (x))
 => '(2 2)
 (begin/collect (begin (begin (begin (define (x) y))
                              (begin (define-syntax-rule (DEF x y)
                                       (define x y))))
                       (begin (begin (define y 2))
                              (begin (x)))
                       (begin (x))))
 => '(2 2)
 (begin/collect 1
                (define (f x #:< [< "<"] #:> [> ">"]) (list < x >))
                (f 1)
                (f #:< "[" 2)
                (f 3 #:> "]" #:< "["))
 => '(1 ("<" 1 ">") ("[" 2 ">") ("[" 3 "]"))

 ;; preprocessor functionality
 (parameterize ([current-directory text-dir])
   (for ([ifile (map path->string (directory-list))]
         #:when (and (file-exists? ifile)
                     (regexp-match? #rx"^i[0-9]+\\.ss$" ifile)))
     (define ofile (regexp-replace #rx"^i([0-9]+)\\..*$" ifile "o\\1.txt"))
     (define expected (call-with-input-file ofile
                        (lambda (i) (read-bytes (file-size ofile) i))))
     (define o (open-output-bytes))
     (parameterize ([current-output-port o])
       (dynamic-require (path->complete-path ifile) #f))
     (test (get-output-bytes o) => expected)))

 )
