-- Module generated by TTA Codesign Environment
-- 
-- Generated on Sun Jul  7 16:19:19 2019
-- 
-- Function Unit: alu_comp
-- 
-- Operations:
--  add  :  0
--  and  :  1
--  eq   :  2
--  gt   :  3
--  gtu  :  4
--  ior  :  5
--  mul  :  6
--  shl  :  7
--  shr  :  8
--  shru :  9
--  sub  : 10
--  xor  : 11
-- 

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_misc.all;

entity fu_alu_comp is
  port (
    clk : in std_logic;
    rstx : in std_logic;
    glock_in : in std_logic;
    glockreq_out : out std_logic;
    operation_in : in std_logic_vector(4-1 downto 0);
    data_in1t_in : in std_logic_vector(32-1 downto 0);
    load_in1t_in : in std_logic;
    data_in2_in : in std_logic_vector(32-1 downto 0);
    load_in2_in : in std_logic;
    data_out1_out : out std_logic_vector(32-1 downto 0);
    data_out2_out : out std_logic_vector(32-1 downto 0);
    data_out3_out : out std_logic_vector(32-1 downto 0));
end entity fu_alu_comp;

architecture rtl of fu_alu_comp is

  constant op_add_c : std_logic_vector(3 downto 0) := "0000";
  constant op_and_c : std_logic_vector(3 downto 0) := "0001";
  constant op_eq_c : std_logic_vector(3 downto 0) := "0010";
  constant op_gt_c : std_logic_vector(3 downto 0) := "0011";
  constant op_gtu_c : std_logic_vector(3 downto 0) := "0100";
  constant op_ior_c : std_logic_vector(3 downto 0) := "0101";
  constant op_mul_c : std_logic_vector(3 downto 0) := "0110";
  constant op_shl_c : std_logic_vector(3 downto 0) := "0111";
  constant op_shr_c : std_logic_vector(3 downto 0) := "1000";
  constant op_shru_c : std_logic_vector(3 downto 0) := "1001";
  constant op_sub_c : std_logic_vector(3 downto 0) := "1010";
  constant op_xor_c : std_logic_vector(3 downto 0) := "1011";

  signal operation : std_logic_vector(3 downto 0);
  signal mul_dsp_2cycle_1_clk : std_logic;
  signal mul_dsp_2cycle_1_rstx : std_logic;
  signal mul_dsp_2cycle_1_glock_in : std_logic;
  signal mul_dsp_2cycle_1_load_in : std_logic;
  signal mul_dsp_2cycle_1_operand_a_in : std_logic_vector(31+1-1 downto 0);
  signal mul_dsp_2cycle_1_operand_b_in : std_logic_vector(31+1-1 downto 0);
  signal mul_dsp_2cycle_1_operand_c_in : std_logic_vector(31+1-1 downto 0);
  signal mul_dsp_2cycle_1_result_out : std_logic_vector(31+1-1 downto 0);
  signal generic_sru_1_clk : std_logic;
  signal generic_sru_1_opa_i : std_logic_vector(31+1-1 downto 0);
  signal generic_sru_1_opb_i : std_logic_vector(31+1-1 downto 0);
  signal generic_sru_1_shift_dir_i : std_logic;
  signal generic_sru_1_arith_shift_i : std_logic;
  signal generic_sru_1_rnd_en_i : std_logic;
  signal generic_sru_1_rnd_mode_i : std_logic;
  signal generic_sru_1_data_o : std_logic_vector(31+1-1 downto 0);
  signal add_op1 : std_logic_vector(31 downto 0);
  signal add_op2 : std_logic_vector(31 downto 0);
  signal add_op3 : std_logic_vector(31 downto 0);
  signal and_op1 : std_logic_vector(31 downto 0);
  signal and_op2 : std_logic_vector(31 downto 0);
  signal and_op3 : std_logic_vector(31 downto 0);
  signal eq_op1 : std_logic_vector(31 downto 0);
  signal eq_op2 : std_logic_vector(31 downto 0);
  signal eq_op3 : std_logic;
  signal gt_op1 : std_logic_vector(31 downto 0);
  signal gt_op2 : std_logic_vector(31 downto 0);
  signal gt_op3 : std_logic;
  signal gtu_op1 : std_logic_vector(31 downto 0);
  signal gtu_op2 : std_logic_vector(31 downto 0);
  signal gtu_op3 : std_logic;
  signal ior_op1 : std_logic_vector(31 downto 0);
  signal ior_op2 : std_logic_vector(31 downto 0);
  signal ior_op3 : std_logic_vector(31 downto 0);
  signal mul_op1 : std_logic_vector(31 downto 0);
  signal mul_op2 : std_logic_vector(31 downto 0);
  signal mul_op3 : std_logic_vector(31 downto 0);
  signal shl_op1 : std_logic_vector(31 downto 0);
  signal shl_op2 : std_logic_vector(4 downto 0);
  signal shl_op3 : std_logic_vector(31 downto 0);
  signal shr_op1 : std_logic_vector(31 downto 0);
  signal shr_op2 : std_logic_vector(4 downto 0);
  signal shr_op3 : std_logic_vector(31 downto 0);
  signal shru_op1 : std_logic_vector(31 downto 0);
  signal shru_op2 : std_logic_vector(4 downto 0);
  signal shru_op3 : std_logic_vector(31 downto 0);
  signal sub_op1 : std_logic_vector(31 downto 0);
  signal sub_op2 : std_logic_vector(31 downto 0);
  signal sub_op3 : std_logic_vector(31 downto 0);
  signal xor_op1 : std_logic_vector(31 downto 0);
  signal xor_op2 : std_logic_vector(31 downto 0);
  signal xor_op3 : std_logic_vector(31 downto 0);
  signal data_in1t : std_logic_vector(31 downto 0);
  signal data_in2 : std_logic_vector(31 downto 0);

  signal shadow_in2_r : std_logic_vector(31 downto 0);
  signal operation_1_r : std_logic_vector(3 downto 0);
  signal optrig_1_r : std_logic;
  signal operation_2_r : std_logic_vector(3 downto 0);
  signal optrig_2_r : std_logic;
  signal data_in1t_1_r : std_logic_vector(31 downto 0);
  signal data_in2_1_r : std_logic_vector(31 downto 0);
  signal trigger_in1t_1_r : std_logic;
  signal trigger_in2_1_r : std_logic;
  signal data_in1t_2_r : std_logic_vector(31 downto 0);
  signal data_in1t_3_r : std_logic_vector(31 downto 0);
  signal trigger_in1t_2_r : std_logic;
  signal data_in2_2_r : std_logic_vector(31 downto 0);
  signal data_in2_3_r : std_logic_vector(31 downto 0);
  signal trigger_in2_2_r : std_logic;
  signal optrig_3_r : std_logic;
  signal operation_3_r : std_logic_vector(3 downto 0);
  signal data_out1_out_r : std_logic_vector(31 downto 0);
  signal data_out2_out_r : std_logic_vector(31 downto 0);
  signal data_out3_out_r : std_logic_vector(31 downto 0);

  component mul_dsp48 is
    generic (
      latency_g : integer);
    port (
      clk : in std_logic;
      rstx : in std_logic;
      glock_in : in std_logic;
      load_in : in std_logic;
      operand_a_in : in std_logic_vector(31+1-1 downto 0);
      operand_b_in : in std_logic_vector(31+1-1 downto 0);
      operand_c_in : in std_logic_vector(31+1-1 downto 0);
      result_out : out std_logic_vector(31+1-1 downto 0));
  end component mul_dsp48;

  component generic_sru is
    port (
      clk : in std_logic;
      opa_i : in std_logic_vector(31+1-1 downto 0);
      opb_i : in std_logic_vector(31+1-1 downto 0);
      shift_dir_i : in std_logic;
      arith_shift_i : in std_logic;
      rnd_en_i : in std_logic;
      rnd_mode_i : in std_logic;
      data_o : out std_logic_vector(31+1-1 downto 0));
  end component generic_sru;

begin

  mul_dsp_2cycle_1 : mul_dsp48
    generic map (
      latency_g => 2)
    port map (
      clk => clk,
      rstx => rstx,
      glock_in => mul_dsp_2cycle_1_glock_in,
      load_in => mul_dsp_2cycle_1_load_in,
      operand_a_in => mul_dsp_2cycle_1_operand_a_in,
      operand_b_in => mul_dsp_2cycle_1_operand_b_in,
      operand_c_in => mul_dsp_2cycle_1_operand_c_in,
      result_out => mul_dsp_2cycle_1_result_out);

  generic_sru_1 : generic_sru
    port map (
      clk => clk,
      opa_i => generic_sru_1_opa_i,
      opb_i => generic_sru_1_opb_i,
      shift_dir_i => generic_sru_1_shift_dir_i,
      arith_shift_i => generic_sru_1_arith_shift_i,
      rnd_en_i => generic_sru_1_rnd_en_i,
      rnd_mode_i => generic_sru_1_rnd_mode_i,
      data_o => generic_sru_1_data_o);

  add_op1 <= data_in1t_1_r;
  add_op2 <= data_in2_1_r;
  and_op1 <= data_in2_1_r;
  and_op2 <= data_in1t_1_r;
  eq_op1 <= data_in1t_1_r;
  eq_op2 <= data_in2_1_r;
  gt_op1 <= data_in1t_1_r;
  gt_op2 <= data_in2_1_r;
  gtu_op1 <= data_in1t_1_r;
  gtu_op2 <= data_in2_1_r;
  ior_op1 <= data_in2_1_r;
  ior_op2 <= data_in1t_1_r;
  mul_op1 <= data_in2_1_r;
  mul_op2 <= data_in1t_1_r;
  shl_op1 <= data_in1t_2_r;
  shl_op2 <= data_in2_2_r(4 downto 0);
  shr_op1 <= data_in1t_2_r;
  shr_op2 <= data_in2_2_r(4 downto 0);
  shru_op1 <= data_in1t_2_r;
  shru_op2 <= data_in2_2_r(4 downto 0);
  sub_op1 <= data_in1t_1_r;
  sub_op2 <= data_in2_1_r;
  xor_op1 <= data_in2_1_r;
  xor_op2 <= data_in1t_1_r;
  data_in1t <= data_in1t_in;

  shadow_in2_sp : process(clk, rstx)
  begin
    if rstx = '0' then
      shadow_in2_r <= (others => '0');
    elsif clk = '1' and clk'event then
      if ((glock_in = '0') and (load_in2_in = '1')) then
        shadow_in2_r <= data_in2_in;
      end if;
    end if;
  end process shadow_in2_sp;

  shadow_in2_cp : process(shadow_in2_r, data_in2_in, load_in2_in, load_in1t_in)
  begin
    if ((load_in1t_in = '1') and (load_in2_in = '1')) then
      data_in2 <= data_in2_in;
    else
      data_in2 <= shadow_in2_r;
    end if;
  end process shadow_in2_cp;

  operations_actual_cp : process(operation_2_r, shru_op2, shr_op2, generic_sru_1_data_o, shl_op2, eq_op2, eq_op1, ior_op2, and_op2, and_op1, add_op2, add_op1, gt_op2, xor_op2, glock_in, mul_op1, operation_1_r, mul_dsp_2cycle_1_result_out, mul_op2, xor_op1, gt_op1, gtu_op1, shru_op1, gtu_op2, ior_op1, sub_op2, sub_op1, shr_op1, shl_op1)
  begin
    add_op3 <= (others => '-');
    and_op3 <= (others => '-');
    eq_op3 <= '-';
    gt_op3 <= '-';
    gtu_op3 <= '-';
    ior_op3 <= (others => '-');
    mul_op3 <= (others => '-');
    shl_op3 <= (others => '-');
    shr_op3 <= (others => '-');
    shru_op3 <= (others => '-');
    sub_op3 <= (others => '-');
    xor_op3 <= (others => '-');
    add_op3 <= (others => '-');
    and_op3 <= (others => '-');
    eq_op3 <= '-';
    eq_op3 <= '-';
    gt_op3 <= '-';
    gt_op3 <= '-';
    gtu_op3 <= '-';
    gtu_op3 <= '-';
    ior_op3 <= (others => '-');
    mul_dsp_2cycle_1_glock_in <= '-';
    mul_op3 <= (others => '-');
    mul_dsp_2cycle_1_load_in <= '-';
    mul_dsp_2cycle_1_operand_a_in <= (others => '-');
    mul_dsp_2cycle_1_operand_b_in <= (others => '-');
    mul_dsp_2cycle_1_operand_c_in <= (others => '-');
    mul_dsp_2cycle_1_load_in <= '-';
    mul_dsp_2cycle_1_glock_in      <= glock_in;
    mul_op3             <= mul_dsp_2cycle_1_result_out;
    mul_dsp_2cycle_1_load_in       <= '0';
    sub_op3 <= (others => '-');
    xor_op3 <= (others => '-');
    case operation_1_r is
      when op_add_c =>
        add_op3 <= std_logic_vector(signed(add_op1) + signed(add_op2));
      when op_and_c =>
        and_op3 <= and_op1 and and_op2;
      when op_eq_c =>
        if eq_op1 = eq_op2 then
          eq_op3 <= '1';
        else
          eq_op3 <= '0';
        end if;
      when op_gt_c =>
        if signed(gt_op1) > signed(gt_op2) then
          gt_op3 <= '1';
        else
          gt_op3 <= '0';
        end if;
      when op_gtu_c =>
        if unsigned(gtu_op1) > unsigned(gtu_op2) then
          gtu_op3 <= '1';
        else
          gtu_op3 <= '0';
        end if;
      when op_ior_c =>
        ior_op3 <= ior_op1 or ior_op2;
      when op_mul_c =>
        mul_dsp_2cycle_1_operand_a_in  <= mul_op1;
        mul_dsp_2cycle_1_operand_b_in  <= mul_op2;
        mul_dsp_2cycle_1_operand_c_in  <= (others => '0');
        mul_dsp_2cycle_1_load_in       <= '1';
      when op_sub_c =>
        sub_op3 <= std_logic_vector(signed(sub_op1) - signed(sub_op2));
      when op_xor_c =>
        xor_op3 <= xor_op1 xor xor_op2;
      when others =>
    end case;
    generic_sru_1_opa_i <= (others => '-');
    generic_sru_1_opb_i <= (others => '-');
    generic_sru_1_shift_dir_i <= '-';
    generic_sru_1_arith_shift_i <= '-';
    generic_sru_1_rnd_en_i <= '-';
    generic_sru_1_rnd_mode_i <= '-';
    shl_op3 <= (others => '-');
    generic_sru_1_opa_i <= (others => '-');
    generic_sru_1_opb_i <= (others => '-');
    generic_sru_1_shift_dir_i <= '-';
    generic_sru_1_arith_shift_i <= '-';
    generic_sru_1_rnd_en_i <= '-';
    generic_sru_1_rnd_mode_i <= '-';
    shr_op3 <= (others => '-');
    generic_sru_1_opa_i <= (others => '-');
    generic_sru_1_opb_i <= (others => '-');
    generic_sru_1_shift_dir_i <= '-';
    generic_sru_1_arith_shift_i <= '-';
    generic_sru_1_rnd_en_i <= '-';
    generic_sru_1_rnd_mode_i <= '-';
    shru_op3 <= (others => '-');
    case operation_2_r is
      when op_shl_c =>
        generic_sru_1_opa_i         <= shl_op1;
        generic_sru_1_opb_i         <= "000000000000000000000000000" & shl_op2;
        generic_sru_1_shift_dir_i   <= '1'; -- 0: right, 1: left (shift dreiction)
        generic_sru_1_arith_shift_i <= '0'; -- 0: logical, 1: arithmetical (only for right shifts)
        generic_sru_1_rnd_en_i      <= '0';
        generic_sru_1_rnd_mode_i    <= '0';
        shl_op3             <= generic_sru_1_data_o;
      when op_shr_c =>
        generic_sru_1_opa_i         <= shr_op1;
        generic_sru_1_opb_i         <= "000000000000000000000000000" & shr_op2;
        generic_sru_1_shift_dir_i   <= '0'; -- 0: right, 1: left (shift dreiction)
        generic_sru_1_arith_shift_i <= '1'; -- 0: logical, 1: arithmetical (only for right shifts)
        generic_sru_1_rnd_en_i      <= '0';
        generic_sru_1_rnd_mode_i    <= '0';
        shr_op3             <= generic_sru_1_data_o;
      when op_shru_c =>
        generic_sru_1_opa_i         <= shru_op1;
        generic_sru_1_opb_i         <= "000000000000000000000000000" & shru_op2;
        generic_sru_1_shift_dir_i   <= '0'; -- 0: right, 1: left (shift dreiction)
        generic_sru_1_arith_shift_i <= '0'; -- 0: logical, 1: arithmetical (only for right shifts)
        generic_sru_1_rnd_en_i      <= '0';
        generic_sru_1_rnd_mode_i    <= '0';
        shru_op3             <= generic_sru_1_data_o;
      when others =>
    end case;
  end process operations_actual_cp;

  operation <= operation_3_r;

  operation_input_sp : process(clk, rstx)
  begin
    if rstx = '0' then
      data_in2_1_r <= (others => '0');
      data_in1t_1_r <= (others => '0');
      operation_1_r <= (others => '0');
      operation_3_r <= (others => '0');
      optrig_3_r <= '0';
      trigger_in2_2_r <= '0';
      data_in1t_2_r <= (others => '0');
      data_in2_3_r <= (others => '0');
      trigger_in2_1_r <= '0';
      trigger_in1t_2_r <= '0';
      data_in2_2_r <= (others => '0');
      operation_2_r <= (others => '0');
      trigger_in1t_1_r <= '0';
      data_in1t_3_r <= (others => '0');
      optrig_1_r <= '0';
      optrig_2_r <= '0';
    elsif clk = '1' and clk'event then
      if (glock_in = '0') then
        trigger_in1t_1_r <= load_in1t_in;
        trigger_in1t_2_r <= trigger_in1t_1_r;
        trigger_in2_1_r <= load_in1t_in;
        trigger_in2_2_r <= trigger_in2_1_r;
        if (trigger_in1t_1_r = '1') then
          data_in1t_2_r <= data_in1t_1_r;
        end if;
        if (trigger_in1t_2_r = '1') then
          data_in1t_3_r <= data_in1t_2_r;
        end if;
        if (trigger_in2_1_r = '1') then
          data_in2_2_r <= data_in2_1_r;
        end if;
        if (trigger_in2_2_r = '1') then
          data_in2_3_r <= data_in2_2_r;
        end if;
        optrig_1_r <= '0';
        optrig_2_r <= optrig_1_r;
        if (optrig_1_r = '1') then
          operation_2_r <= operation_1_r;
        end if;
        optrig_3_r <= optrig_2_r;
        if (optrig_2_r = '1') then
          operation_3_r <= operation_2_r;
        end if;
      end if;
      if ((glock_in = '0') and (load_in1t_in = '1')) then
        case operation_in is
          when op_add_c =>
            operation_1_r <= operation_in;
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
          when op_and_c =>
            operation_1_r <= operation_in;
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
          when op_eq_c =>
            operation_1_r <= operation_in;
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
          when op_gt_c =>
            operation_1_r <= operation_in;
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
          when op_gtu_c =>
            operation_1_r <= operation_in;
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
          when op_ior_c =>
            operation_1_r <= operation_in;
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
          when op_mul_c =>
            operation_1_r <= operation_in;
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
          when op_shl_c =>
            operation_1_r <= operation_in;
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
          when op_shr_c =>
            operation_1_r <= operation_in;
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
          when op_shru_c =>
            operation_1_r <= operation_in;
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
          when op_sub_c =>
            operation_1_r <= operation_in;
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
          when op_xor_c =>
            operation_1_r <= operation_in;
            data_in2_1_r <= data_in2;
            optrig_1_r <= '1';
            data_in1t_1_r <= data_in1t;
            optrig_1_r <= '1';
          when others =>
        end case;
      end if;
    end if;
  end process operation_input_sp;
  data_out1_out <= data_out1_out_r;
  data_out2_out <= data_out2_out_r;
  data_out3_out <= data_out3_out_r;

  operations_output_sp : process(clk, rstx)
  begin
    if rstx = '0' then
      data_out3_out_r <= (others => '0');
      data_out2_out_r <= (others => '0');
      data_out1_out_r <= (others => '0');
    elsif clk = '1' and clk'event then
      if ((glock_in = '0') and (optrig_1_r = '1')) then
        case operation_1_r is
          when op_add_c =>
            data_out1_out_r <= add_op3;
          when op_and_c =>
            data_out1_out_r <= and_op3;
          when op_eq_c =>
            data_out1_out_r <= ((32-1 downto 1 => '0') & eq_op3);
          when op_gt_c =>
            data_out1_out_r <= ((32-1 downto 1 => '0') & gt_op3);
          when op_gtu_c =>
            data_out1_out_r <= ((32-1 downto 1 => '0') & gtu_op3);
          when op_ior_c =>
            data_out1_out_r <= ior_op3;
          when op_sub_c =>
            data_out1_out_r <= sub_op3;
          when op_xor_c =>
            data_out1_out_r <= xor_op3;
          when others =>
        end case;
      end if;
      if ((glock_in = '0') and (optrig_2_r = '1')) then
        case operation_2_r is
          when op_shl_c =>
            data_out2_out_r <= shl_op3;
          when op_shr_c =>
            data_out2_out_r <= shr_op3;
          when op_shru_c =>
            data_out2_out_r <= shru_op3;
          when others =>
        end case;
      end if;
      if ((glock_in = '0') and (optrig_3_r = '1')) then
        case operation_3_r is
          when op_mul_c =>
            data_out3_out_r <= mul_op3;
          when others =>
        end case;
      end if;
    end if;
  end process operations_output_sp;

  glockreq_out <= '0';

end architecture rtl;

