
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#ifndef POLYGRAPH__PGL_AGENTSYM_H
#define POLYGRAPH__PGL_AGENTSYM_H

#include "base/UniqId.h"
#include "pgl/PglNumSym.h"
#include "pgl/HostsBasedSym.h"

class StrIdentifier;
class StringSym;
class SocketSym;
class PopModelSym;
class SslWrapSym;

// base class for robot and server symbols
class AgentSym: public HostsBasedSym {
	public:
		static String TheType;

	public:
		AgentSym(const String &aType);
		AgentSym(const String &aType, PglRec *aRec);

		virtual bool isA(const String &type) const;

		String kind() const;
		UniqId world() const;
		RndDistr *httpVersions(const StrIdentifier &versionNames) const;
		SocketSym *socket() const;
		RndDistr *xactThink() const;
		RndDistr *pconnUseLmt() const;
		Time idlePconnTimeout() const;
		PopModelSym *popModel() const;
		bool msgTypes(Array<StringSym*> &types, Array<double> &tprobs) const;
		RndDistr *msgTypes(const StrIdentifier &typeNames) const;
		bool abortProb(double &p) const;
		bool cookieSender(double &prob) const;
		bool sslWraps(Array<SslWrapSym*> &syms, RndDistr *&sel) const;

	protected:
		virtual String msgTypesField() const = 0;
};

#endif
