/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"
#include "polyxedit-ui-masses-display-wnd.h"
#include "polyxedit-ui-seqed-wnd.h"

gboolean
polyxedit_init (void)
{
  /* Initialize the strings that will be needed to feed GtkComboBox
     objects used when setting up searching/finding masses (declared
     in the polyxedit-globals.h file):
  */
  polyxedit_tolerance_units_amu = g_strdup (_("Atomic Mass Unit"));
  polyxedit_tolerance_units_pct = g_strdup (_("Percentage"));
  polyxedit_tolerance_units_ppm = g_strdup (_("Part Per Million"));

  /* Initialize the pointer to the last active edit context.
   */
  polyxedit_last_editctxt = NULL;

  /* Construct the window where the masses are going to be displayed.
   */
  polyxedit_masses_display_wnd = 
    polyxedit_ui_masses_display_wnd_setup_window ();
  
  if (polyxedit_masses_display_wnd == NULL)
    {
      g_error (_("%s@%d: failed to create the masses display window\n"),
	     __FILE__, __LINE__);
    }

  /* Note that we do not want that the window be visible until the user
     ask for it through the general menu of the program.
  */
  gtk_widget_hide (GTK_WIDGET (polyxedit_masses_display_wnd));

  /* Initialize the array that will contain all the polyxedit contexts
     (PxmEditCtxt instances) made on behalf of the polymer
     sequence editor module (polyxedit).
  */
  polyxedit_editctxtGPA = g_ptr_array_new ();

  polyxedit_uninitialized = FALSE;

  return TRUE;
}



gboolean
polyxedit_uninit (void)
{
  GtkWidget *dialog = NULL;

  gint iter = 0;
  gint result = 0;

  gchar *help = NULL;
    
  PxmEditCtxt *editctxt = NULL;
  

  /* Since this function might be called more than once in a single 
     GNU polyxmass session, we must ensure that what we might free 
     here in the first run does not get freed a second time, otherwise
     crash guaranteed!
  */
  if (polyxedit_uninitialized == TRUE)
    return TRUE;
  


  /* This function is called right before leaving the GNU polyxmass
     program, by the polyxmass_main_uninit_program () function.
  */


  /* We start by checking if some sequences are still opened and NOT
     saved. 

     It is important NOT to start freeing other housekeeping data
     because if we return from exiting (the user chooses not to quit
     the polyxedit module because he is given a chance to save a
     polymer sequence, for example), we might well come to this
     function again, or the user might want to continue the working
     session. In those cases, if the housekeepiing data have been
     freed, the crsh is guaranteed !
  */

  /* We only return TRUE is all the sequences that are opened (if any) 
     are unmodified. Since we might remove one or more items, as
     usual, we iterate in the array in the reverse order.
  */
  for (iter = polyxedit_editctxtGPA->len - 1; iter >= 0 ; iter--) 
    {
      editctxt = g_ptr_array_index (polyxedit_editctxtGPA, iter);
      g_assert (editctxt != NULL);
      
      if (FALSE == pxmchem_polymer_get_modified (editctxt->polymer))
	polyxedit_seqed_wnd_close (editctxt);
    }
  
  /* Check if we still have editctxt instances in the array. If not,
     then we can go on with the freeing work...
  */
  if (polyxedit_editctxtGPA->len <= 0)
    {
      polyxedit_editctxt_GPA_free (polyxedit_editctxtGPA);
      
      if (polyxedit_masses_display_wnd != NULL)
	gtk_object_destroy (GTK_OBJECT (polyxedit_masses_display_wnd));
      
      if (NULL != polyxedit_tolerance_units_amu)
	g_free (polyxedit_tolerance_units_amu);
      
      if (NULL != polyxedit_tolerance_units_pct)
	g_free (polyxedit_tolerance_units_pct);
      
      if (NULL != polyxedit_tolerance_units_ppm)
	g_free (polyxedit_tolerance_units_ppm);
      
      polyxedit_uninitialized = TRUE;
      
      return TRUE;
    }

  /* Apparently, there remains at least one sequence that is not
     saved.
  */

  help = g_strdup_printf (_("GNU polyxedit: %d unsaved sequence(s) "
			    "still opened. \nQuit Anyway ?"),
			  polyxedit_editctxtGPA->len);
  
  dialog = gtk_message_dialog_new (GTK_WINDOW (polyxmass_main_wnd),
				   GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_QUESTION,
				   GTK_BUTTONS_YES_NO,
				   help);

  g_free (help);
  				  
/*
  dialog = gtk_dialog_new_with_buttons 
    (_("GNU polyxedit: UNSAVED sequences"),
     polyxmass_main_wnd,
     GTK_DIALOG_MODAL 
     | GTK_DIALOG_DESTROY_WITH_PARENT,
     _("Exit Anyway"), GTK_RESPONSE_ACCEPT,
     _("Cancel"), GTK_RESPONSE_REJECT,
     NULL);
*/

  result = gtk_dialog_run (GTK_DIALOG (dialog));
  
  if (result != GTK_RESPONSE_YES)
    {
      /* The user does not want to "Exit Anyway", so we just destroy
	 the dialog widget and we return FALSE, so that GNU polyxmass
	 knows that exiting the program is aborted. Note that
	 polyxedit_uninitialized, which was FALSE at the entering of
	 this function remains FALSE: it will be possible to continue
	 work as usual and come back to this function later...
      */
      gtk_widget_destroy (dialog);
      
      return FALSE;
    }
  

  /* At this point, we know that the user wanted to exit the polyxedit
     module even if one or more polymer sequence(s) is(were) modified.
     
     Continue the freeing work.
  */
  gtk_widget_destroy (dialog);
  
  polyxedit_editctxt_GPA_free (polyxedit_editctxtGPA);
  
  if (polyxedit_masses_display_wnd != NULL)
    gtk_object_destroy (GTK_OBJECT (polyxedit_masses_display_wnd));
  
  if (NULL != polyxedit_tolerance_units_amu)
    g_free (polyxedit_tolerance_units_amu);
  
  if (NULL != polyxedit_tolerance_units_pct)
    g_free (polyxedit_tolerance_units_pct);

  if (NULL != polyxedit_tolerance_units_ppm)
    g_free (polyxedit_tolerance_units_ppm);

  polyxedit_uninitialized = TRUE;
  
  return TRUE;
}


