/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-ui-seqed-window-menu.h"

#include "polyxedit-editctxt.h"
#include "polyxedit-seqeditorctxt.h"
#include "polyxedit-ui-seqed-wnd.h"
#include "polyxedit-ui-seqed-kbd.h"
#include "polyxedit-ui-seqed-clipboard.h"
#include "polyxedit-ui-calculations-opt.h"
#include "polyxedit-ui-monomer-modif.h"
#include "polyxedit-ui-polymer-modif.h"
#include "polyxedit-ui-cleave-options.h"
#include "polyxedit-ui-fragment-options.h"
#include "polyxedit-ui-elemcompos.h"
#include "polyxedit-ui-mnmcompos.h"
#include "polyxedit-ui-searchmass-options.h"
#include "polyxedit-ui-note.h"
#include "polyxedit-ui-findrep-options.h"
#include "polyxedit-acidobasic.h"
#include "polyxmass-ui-mz-ratio.h"
#include "polyxedit-ui-reportopt.h"
#include "polyxmass-ui-main.h"




GtkWidget *
polyxedit_seqed_window_menubar_setup (GladeXML *xml, PxmEditCtxt *editctxt)
{
  GtkWidget *widget = NULL;

  GtkWidget *seqed_menubar = NULL;
    
  PxmSeqEditorCtxt *seqeditorctxt = NULL;
  

  g_assert (editctxt != NULL);
  
  seqeditorctxt = editctxt->seqeditorctxt;
  g_assert (seqeditorctxt != NULL);
  
  g_assert (seqeditorctxt->sequence_editor_wnd != NULL);
  

  /* We must create the menu items starting with the xml pointer
     that's passed as a parameter, otherwise the menu won't work.
  */

  g_assert (xml != NULL);
    
  /* Creation of the menubar.
   */
  seqed_menubar = glade_xml_get_widget (xml, "seqed_menubar");
  g_assert (seqed_menubar != NULL);

  
  /* Now that we got grasp of the menubar, we can attach all the
     handlers to its submenu items.
  */

  /* SAVE MENUITEM
   */
  widget = glade_xml_get_widget (xml, "polyxedit_seqed_window_menu_file_save");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_file_save", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK (polyxedit_seqed_window_menu_file_save),
		    editctxt);

  /* SAVEAS MENUITEM
   */
  widget = glade_xml_get_widget (xml, "polyxedit_seqed_window_menu_file_saveas");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_file_saveas", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK (polyxedit_seqed_window_menu_file_saveas),
		    editctxt);

  /* CLOSE MENUITEM
   */
  widget = glade_xml_get_widget (xml, "polyxedit_seqed_window_menu_file_close");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_file_close", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK (polyxedit_seqed_window_menu_file_close),
		    editctxt);

  /* EDIT MENUITEM
   */
  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_edit_copy");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_edit_copy", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_edit_copy),
		    editctxt);

  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_edit_cut");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_edit_cut", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_edit_cut),
		    editctxt);

  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_edit_paste");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_edit_paste", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_edit_paste),
		    editctxt);

  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_edit_self_read_configuration");
  g_assert (widget != NULL);
  g_object_set_data 
    (G_OBJECT (seqed_menubar),
     "polyxedit_seqed_window_menu_edit_self_read_configuration", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_edit_self_read_configuration),
		    editctxt);


  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_edit_selectall");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_edit_selectall", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_edit_selectall),
		    editctxt);

  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_edit_find");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_edit_find", 
		     widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_edit_find),
		    editctxt);

  
  /* VIEW MENUITEM
   */
  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_view_calculationsoptions");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_view_calculationsoptions", 
		     widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_view_calculationsoptions),
		    editctxt);

  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_view_completionslist");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_view_completionslist", 
		     widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_view_completionslist),
		    editctxt);



  /* CHEMISTRY MENUITEM
   */
  widget = glade_xml_get_widget 
    (xml, 
     "polyxedit_seqed_window_menu_chemistry_modifs_monomer");

  g_assert (widget != NULL);

  g_object_set_data 
    (G_OBJECT (seqed_menubar),
     "polyxedit_seqed_window_menu_chemistry_modifs_monomer", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_chemistry_modifs_monomer),
		    editctxt);
  

  widget = glade_xml_get_widget 
    (xml, 
     "polyxedit_seqed_window_menu_chemistry_modifs_polymer");

  g_assert (widget != NULL);

  g_object_set_data 
    (G_OBJECT (seqed_menubar),
     "polyxedit_seqed_window_menu_chemistry_modifs_polymer", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_chemistry_modifs_polymer),
		    editctxt);
  
  
  widget = glade_xml_get_widget (xml, 
				 "polyxedit_seqed_window_menu_chemistry_cleave");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_chemistry_cleave", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_chemistry_cleave),
		    editctxt);
  
  widget = glade_xml_get_widget (xml, 
				 "polyxedit_seqed_window_menu_chemistry_fragment");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_chemistry_fragment", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_chemistry_fragment),
		    editctxt);
  
  widget = glade_xml_get_widget 
    (xml, "polyxedit_seqed_window_menu_chemistry_compos_elem");
  g_assert (widget != NULL);
  g_object_set_data 
    (G_OBJECT (seqed_menubar),
     "polyxedit_seqed_window_menu_chemistry_compos_elem", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_chemistry_compos_elem),
		    editctxt);
  
  widget = glade_xml_get_widget 
    (xml, "polyxedit_seqed_window_menu_chemistry_compos_mnm");
  g_assert (widget != NULL);
  g_object_set_data 
    (G_OBJECT (seqed_menubar),
     "polyxedit_seqed_window_menu_chemistry_compos_mnm", widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_chemistry_compos_mnm),
		    editctxt);
  
  widget = 
    glade_xml_get_widget 
    (xml, 
     "polyxedit_seqed_window_menu_chemistry_pka_ph_pi_reload_data");

  g_assert (widget != NULL);
  g_object_set_data 
    (G_OBJECT (seqed_menubar),
     "polyxedit_seqed_window_menu_chemistry_pka_ph_pi_reload_data", widget);
  
  g_signal_connect 
    (G_OBJECT (widget),
     "activate",
     G_CALLBACK 
     (polyxedit_seqed_window_menu_chemistry_pka_ph_pi_reload_data),
     editctxt);
  
  widget = 
    glade_xml_get_widget 
    (xml, 
     "polyxedit_seqed_window_menu_chemistry_pka_ph_pi_calculations");
  g_assert (widget != NULL);
  g_object_set_data 
    (G_OBJECT (seqed_menubar),
     "polyxedit_seqed_window_menu_chemistry_pka_ph_pi_calculations", widget);
  
  g_signal_connect 
    (G_OBJECT (widget),
     "activate",
     G_CALLBACK 
     (polyxedit_seqed_window_menu_chemistry_pka_ph_pi_calculations),
     editctxt);
  
  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_chemistry_searchmass");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_chemistry_searchmass", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_chemistry_searchmass),
		    editctxt);

  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_window_menu_chemistry_mz_ratio_calc");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (seqed_menubar),
		     "polyxedit_seqed_window_menu_chemistry_mz_ratio_calc", 
		     widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_chemistry_mz_ratio_calc),
		    editctxt);


  /* REPORT MENUITEM
   */
  widget = glade_xml_get_widget 
    (xml, 
     "polyxedit_seqed_window_menu_reports_report_options");

  g_assert (widget != NULL);

  g_object_set_data 
    (G_OBJECT (seqed_menubar),
     "polyxedit_seqed_window_menu_reports_report_options", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_reports_report_options),
		    editctxt);

  widget = glade_xml_get_widget 
    (xml, 
     "polyxedit_seqed_window_menu_reports_make_reports");

  g_assert (widget != NULL);

  g_object_set_data 
    (G_OBJECT (seqed_menubar),
     "polyxedit_seqed_window_menu_reports_make_reports", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_window_menu_reports_make_reports),
		    editctxt);



  return GTK_WIDGET (seqed_menubar);
}







/* SAVE MENUITEM
 */
void
polyxedit_seqed_window_menu_file_save (GtkMenuItem *menuitem,
				       gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  GtkWidget *window = NULL;
  
  g_assert (editctxt != NULL);
  

  /* The file into which the sequence is to be saved should be in the
     file member of the editctxt->polymer->plminfo structure. Let's
     see if there is such data. If so, we just overwrite this file. If
     not, then that means that we actually should ask the user to
     provide a file name, which is done by calling the _saveas_
     variant of this function.
  */
  g_assert (editctxt->polymer->plminfo->file != NULL);

  if (strlen (editctxt->polymer->plminfo->file) <= 0)
    return polyxedit_seqed_window_menu_file_saveas (NULL, editctxt);

  window = editctxt->seqeditorctxt->sequence_editor_wnd;
  g_assert (window != NULL);
  
  /* All we do is save the sequence to its own file.
   */
  if (-1 == 
      pxmchem_polymer_write_xml_file (editctxt->polymer,
				      editctxt->polymer->plminfo->file,
				      NULL))
    {
      g_critical (_("%s@%d: failed to save polymer sequence to file: '%s'\n"),
	     __FILE__, __LINE__, 
	     editctxt->polymer->plminfo->file);
      
      /* Echo a failure message to the user.
       */
      polyxmass_timeoutmsg_message_set ((GtkWindow *) window,
					_("Failed to save polymer sequence to file"),
					POLYXMASS_NORM_MSG_TIMEOUT);

      return;
    }
  
  /* By definition, a sequence that has been successfully saved to 
     disk is no more dirty:
  */
  polyxedit_seqed_wnd_set_polymer_modified (editctxt, FALSE);

  
  /* Echo a success message to the user.
   */
  polyxmass_timeoutmsg_message_set ((GtkWindow *) window,
				    _("Succeeded to save polymer sequence to file"),
				    POLYXMASS_NORM_MSG_TIMEOUT);
  
  return;
}


/* SAVEAS MENUITEM
 */
void
polyxedit_seqed_window_menu_file_saveas (GtkMenuItem *menuitem,
					 gpointer data)
{
  GtkWidget *dialog = NULL;

  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;

  gchar *filename = NULL;
  gchar *basename = NULL;
  gchar *help = NULL;

  FILE *filep = NULL;
    

  /* We should present the user with a file selection dialog.  If the
     userspec structure has as non-empty datadir member, then we
     should go there immediately.
  */
  
  g_assert (editctxt != NULL);
  g_assert (editctxt->polymer != NULL);

  /* Create the file selector */
  dialog = 
    gtk_file_chooser_dialog_new (_("Save Polymer Sequence File"),
				 GTK_WINDOW (editctxt->seqeditorctxt->
					     sequence_editor_wnd),
				 GTK_FILE_CHOOSER_ACTION_SAVE,
				 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				 GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
				 NULL);
  
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
      
      if (TRUE == g_file_test (filename, G_FILE_TEST_EXISTS))
	{
	  g_critical (_("%s@%d: file does exist already: '%s'\n"),
		 __FILE__, __LINE__, filename);
	  
	  g_free (filename);
	  
	  /* We can destroy the file chooser dialog.
	   */
	  gtk_widget_destroy (dialog);

	  return;
	}
    }
  else
    {
      g_free (filename);
      
      /* We can destroy the file chooser dialog.
       */
      gtk_widget_destroy (dialog);
      
      return;
    }
  
  /* We can destroy the file chooser dialog.
   */
  gtk_widget_destroy (dialog);

  /* First of all make sure we can open the file to write to it.
   */
  filep = fopen (filename, "w");
  
  if (filep == NULL)
    {
      g_critical (_("%s@%d: failed to open file: '%s'\n"),
	     __FILE__, __LINE__, filename);
      
      g_free (filename);
      
      return;
    }

  /* All we do is save the sequence to the selected file.
   */
  if (-1 == pxmchem_polymer_write_xml_file (editctxt->polymer,
					    filename,
					    NULL))
    {
      g_critical (_("%s@%d: failed to save polymer sequence to file: '%s'\n"),
	     __FILE__, __LINE__, filename);
      
      /* Echo a failure message to the user.
       */
      polyxmass_timeoutmsg_message_set 
	((GtkWindow *) editctxt->seqeditorctxt->sequence_editor_wnd,
	 _("Failed to save polymer sequence to file"),
	 POLYXMASS_LONG_MSG_TIMEOUT);
      
      g_free (filename);
      
      return;
    }
  
  g_free (filename);
  

  /* By definition, a sequence that has been successfully saved to 
     disk is no more dirty:
  */
  polyxedit_seqed_wnd_set_polymer_modified (editctxt, FALSE);

  /* Set the title of the window itself:
   */
  basename = g_path_get_basename (editctxt->polymer->plminfo->file);
  help = g_strdup_printf ("polyxedit: %s", basename);
  gtk_window_set_title 
    (GTK_WINDOW (editctxt->seqeditorctxt->sequence_editor_wnd), help);
  g_free (help);
  g_free (basename);
  
  /* Echo a success message to the user.
   */
  polyxmass_timeoutmsg_message_set ((GtkWindow *) editctxt->seqeditorctxt->
				    sequence_editor_wnd,
				    _("Succeeded to save polymer sequence to file"),
				    POLYXMASS_NORM_MSG_TIMEOUT);


  return ;
}


/* CLOSE MENUITEM
 */
void
polyxedit_seqed_window_menu_file_close (GtkMenuItem *menuitem,
					gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  
  g_assert (editctxt != NULL);
  
  polyxedit_seqed_wnd_delete_event (NULL, NULL, editctxt);
   
 return;
}


/* EDIT MENUITEM
 */
void
polyxedit_seqed_window_menu_edit_copy (GtkMenuItem *menuitem,
				       gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);

  /* Just call the function that's responsible for that work:
   */
  polyxedit_seqed_clipboard_copy (editctxt);
  
  return;
}


void
polyxedit_seqed_window_menu_edit_cut (GtkMenuItem *menuitem,
				      gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);

  /* Just call the function that's responsible for that work:
   */
  polyxedit_seqed_clipboard_cut (editctxt);
  
  return;
}


void
polyxedit_seqed_window_menu_edit_paste (GtkMenuItem *menuitem,
				      gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);

  /* Just call the function that's responsible for that work:
   */
  polyxedit_seqed_clipboard_paste (editctxt);
  
  return;
}


void
polyxedit_seqed_window_menu_edit_self_read_configuration (GtkMenuItem *menuitem,
							  gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);

  /* Just call the function that's responsible for that work:
   */
  polyxedit_seqed_wnd_self_read_configuration (editctxt);
  
  return;
}


void
polyxedit_seqed_window_menu_edit_selectall (GtkMenuItem *menuitem,
					    gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);

  /* Just call the function that's responsible for that work:
   */
  polyxedit_seqed_wnd_select_sequence (editctxt, -1, -1);
  
  return;
}


void
polyxedit_seqed_window_menu_edit_find (GtkMenuItem *menuitem,
					       gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);

  /*
    We are willing to find (with or without replace) a sequence motif
    in the polymer sequence; so just launch the window.
  */
  if (NULL == polyxedit_findrep_opt_setup_wnd (editctxt))
    {
      g_critical (_("%s@%d: failed to display the find/replace window.\n"),
	     __FILE__, __LINE__);
    }

  return;
}


/* VIEW MENUITEM
 */
void
polyxedit_seqed_window_menu_view_calculationsoptions (GtkMenuItem *menuitem,
						       gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  GtkWidget *window = NULL;


  g_assert (editctxt != NULL);

  window = polyxedit_calculations_opt_wnd_setup (editctxt);
  
  if (NULL == window)
    g_error (_("%s@%d: failed to create the calculations options window.\n"),
	   __FILE__, __LINE__);
}


void
polyxedit_seqed_window_menu_view_completionslist (GtkMenuItem *menuitem,
						   gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;

  g_assert (editctxt != NULL);

  if (FALSE == polyxedit_seqed_kbd_check_complete_elab_code (editctxt))
    g_error (_("%s@%d: failed to check complete elab code\n"),
	     __FILE__, __LINE__);
}





/* CHEMISTRY MENUITEM
 */
void
polyxedit_seqed_window_menu_chemistry_modifs_monomer (GtkMenuItem *menuitem,
						      gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);

  if (NULL == polyxedit_ui_monomer_modif_setup_wnd (editctxt))
    g_critical (_("%s@%d: failed to open the monomer modification window\n"),
	   __FILE__, __LINE__);
  
  return ;
}


void
polyxedit_seqed_window_menu_chemistry_modifs_polymer (GtkMenuItem *menuitem,
						      gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);

  if (NULL == polyxedit_ui_polymer_modif_setup_wnd (editctxt))
    g_critical (_("%s@%d: failed to open the polymer modification window\n"),
	   __FILE__, __LINE__);
  
  return ;
}


void
polyxedit_seqed_window_menu_chemistry_cleave (GtkMenuItem *menuitem,
						      gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);


  if (NULL == polyxedit_cleave_opt_wnd_setup (editctxt))
    g_critical (_("%s@%d: failed to open the cleavage options window\n"),
	   __FILE__, __LINE__);
  
  return ;
}


void
polyxedit_seqed_window_menu_chemistry_fragment (GtkMenuItem *menuitem,
						gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);


  if (NULL == polyxedit_fragment_opt_wnd_setup (editctxt))
    g_critical (_("%s@%d: failed to open the fragmentation options window\n"),
	   __FILE__, __LINE__);
  
  return ;
}


void
polyxedit_seqed_window_menu_chemistry_compos_elem (GtkMenuItem *menuitem,
						   gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  GtkWidget *window = NULL;
  
  
  g_assert (editctxt != NULL);
  g_assert (editctxt->seqeditorctxt->sequence_editor_wnd != NULL);


  window = polyxedit_elemcompos_wnd_setup (editctxt);
  
  if (window == NULL)
    {
      g_critical (_("%s@%d: failed to open the elemental composition window\n"),
		  __FILE__, __LINE__);
  
      return;
    }
  
  /* Register this results' window !
   */
  if (NULL == polyxmass_winmngmt_register_window 
      ("POLYXEDIT",
       window,
       editctxt->seqeditorctxt->sequence_editor_wnd,
       editctxt,
       _("Results of Elemental Composition"),
       NULL,
       TRUE,
       polyxedit_elemcompos_wnd_make_report))
    g_critical (_("%s@%d: failed to register the elemental composition "
		  "results' window\n"),
		__FILE__, __LINE__);
  return ;
}


void
polyxedit_seqed_window_menu_chemistry_compos_mnm (GtkMenuItem *menuitem,
						  gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  GtkWidget *window = NULL;
  
  
  g_assert (editctxt != NULL);
  g_assert (editctxt->seqeditorctxt->sequence_editor_wnd != NULL);
  
  window = polyxedit_mnmcompos_wnd_setup (editctxt);
  
  if (window == NULL)
    {
      g_critical (_("%s@%d: failed to open the elemental "
		    "composition window\n"),
		  __FILE__, __LINE__);
      
      return;
    }
  
  /* Register this results' window !
   */
  if (NULL == polyxmass_winmngmt_register_window 
      ("POLYXEDIT",
       window,
       editctxt->seqeditorctxt->sequence_editor_wnd,
       editctxt,
       _("Results of Monomeric Composition"),
       NULL,
       TRUE,
       polyxedit_mnmcompos_wnd_make_report))
    g_critical (_("%s@%d: failed to register the monomeric composition "
		  "results' window\n"),
		__FILE__, __LINE__);
  return ;
}


void
polyxedit_seqed_window_menu_chemistry_pka_ph_pi_reload_data (GtkMenuItem *
							     menuitem, 
							     gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  
  g_assert (editctxt != NULL);
  
  if (FALSE == polyxedit_acidobasic_reload_data (editctxt))
    {
      g_critical (_("%s@%d: failed to reload the acido-basicity "
	       "data from xml file\n"),
	     __FILE__, __LINE__);
    }
 
  return ;
}

void
polyxedit_seqed_window_menu_chemistry_pka_ph_pi_calculations (GtkMenuItem *
							      menuitem, 
							      gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  
  g_assert (editctxt != NULL);
  
  if (FALSE == polyxedit_acidobasic_setup_framework (editctxt))
    {
      g_critical (_("%s@%d: failed to set up the acido-basicity "
	       "calculations framework\n"),
	     __FILE__, __LINE__);
    }

  return ;
}

void
polyxedit_seqed_window_menu_chemistry_searchmass (GtkMenuItem *menuitem,
						  gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  
  g_assert (editctxt != NULL);
  

  if (NULL == polyxedit_searchmass_opt_setup_wnd (editctxt))
    g_critical (_("%s@%d: failed to open the search mass options window\n"),
	   __FILE__, __LINE__);
  
  return ;
}


void
polyxedit_seqed_window_menu_chemistry_mz_ratio_calc (GtkMenuItem *menuitem,
						     gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  GtkWidget *parent_wnd = NULL;
  GtkWidget *window = NULL;

  GPtrArray *atomGPA = NULL;
  

  g_assert (editctxt != NULL);
  
  atomGPA = editctxt->polchemdefctxt->polchemdef->atomGPA;
  g_assert (atomGPA != NULL);
  
  parent_wnd = editctxt->seqeditorctxt->sequence_editor_wnd;
  g_assert (parent_wnd != NULL);
  

  /* We call the mz ratio calculator window with a number of
     parameters and not simply the editctxt pointer, because that same
     window might be called through the polyxcalc module.
  */
  window =  polyxmass_mz_ratio_wnd_setup (atomGPA, 
					  editctxt->ionizerule,
					  parent_wnd,
					  "POLYXEDIT");
 
  if (window == NULL)
    {
      g_critical (_("%s@%d: failed to open the m/z ratio calculator window\n"),
		  __FILE__, __LINE__);
      
      return;
    }

  /* Register this results' window !
   */
  if (NULL == polyxmass_winmngmt_register_window 
      ("POLYXEDIT",
       window,
       editctxt->seqeditorctxt->sequence_editor_wnd,
       editctxt,
       _("Results of m/z Calculations"),
       NULL,
       TRUE,
       polyxmass_mz_ratio_wnd_make_report))
    g_critical (_("%s@%d: failed to register the m/z calculations "
		  "results' window\n"),
		__FILE__, __LINE__);

  return;
}


void
polyxedit_seqed_window_menu_reports_report_options (GtkMenuItem *menuitem,
					       gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  
  GtkWidget *report_opt_wnd = NULL;
  
  g_assert (editctxt != NULL);


  /* We only setup a new report options window if it does not already
     exist in the editctxt.
   */
  report_opt_wnd = g_object_get_data (G_OBJECT (editctxt->seqeditorctxt->
						sequence_editor_wnd), 
				      "report_opt_wnd");

  if (report_opt_wnd == NULL)
    {
      report_opt_wnd = polyxedit_report_opt_wnd_setup (editctxt);
      
      if (NULL == report_opt_wnd)
	{
	  g_critical (_("%s@%d: failed to open the report options window\n"),
		      __FILE__, __LINE__);
	  return;
	}
    }
  else
    {
      gtk_widget_show_all (GTK_WIDGET (report_opt_wnd));
    }
  
  return;
}

void
polyxedit_seqed_window_menu_reports_make_reports (GtkMenuItem *menuitem,
					  gpointer data)
{
  /* The data parameter is editctxt. But we do not use it here.
   */

  GtkWidget *window = NULL;
  

  /* All we want to do is provide the user with the window that lists
     all the registered windows, for her to choose the windows, for
     which the reports have to be done.
   */
  window = (GtkWidget *)
    on_polyxmass_polyxmass_view_window_management_activate (NULL,
							    polyxmass_main_wnd);
  
  if (window == NULL)
    g_critical (_("%s@%d: failed to create the window management window\n"),
		__FILE__, __LINE__);
  
  return;
}

