/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxmass-self-read.h"

 

gchar *
polyxmass_self_read_get_silent_sound_file_name (PxmPolchemdefCtxt *polchemdefctxt)
{
  gchar *dic = NULL;
  gchar *line = NULL; 
  gchar *read = NULL;
  gchar *found = NULL;
  gchar *filename = NULL;

  GString *gs = NULL;
  
  gint iter = 0;
  
  FILE *cfgp = NULL;

  /* We are asked to parse the sounds.dic file corresponding to
     the current polymer chemistry definition context, in search for a line 
     that tells something like 

     silence-sound$silence.ogg

     which is the file name of the sound file that outputs silence.
  */

  g_assert (polchemdefctxt != NULL);
  g_assert (polchemdefctxt->polchemdef != NULL);
  g_assert (polchemdefctxt->polchemdef->dir != NULL);
  
  /* Construct the name of the file that is the sounds dictionary.
   */
  dic =  g_strdup_printf ("%s/sounds/sounds.dic", 
			  polchemdefctxt->polchemdef->dir);
  
  cfgp = fopen (dic, "r");
  
  if (NULL == cfgp)
    {
      g_critical (_("%s@%d: dictionary file of monomer sounds not found: '%s'\n"),
	     __FILE__, __LINE__, dic);

      g_free (dic);
      
      return NULL;
    }

  g_free (dic);
  

  /* Allocate the memory into which each line of the file will be
   * stored for recursive parsing.
   */
  line = g_malloc0 (sizeof (gchar) * (MAX_LINE_LENGTH + 1));

  read = line;

  while (read != NULL)
    {
      read = fgets (read, MAX_LINE_LENGTH, cfgp);
      
      if (read != NULL && strlen (read) > 1)
	{
	  /* Check if the line is a comment:
	   */
	  if (read [0] == '#')
	    continue;
	  
	  /* Check if the line is the one we're looking for:
	   */
	  if (NULL == strstr (read, "silence-sound$"))
	    continue;


	  /* At this point, we have that line!
	   */
	  found = strchr (line, '$');
	  
	  /* We want to skip the '$'.
	   */
	  iter++;
	  
	  gs = g_string_new ("");
	  
	  while (found [iter] != '\x0' && found [iter] != '\n')
	    {
	      gs = g_string_append_c (gs, found [iter]);
	      
	      iter++;
	    }
	  
	  /* At this point, gs should contain the file name of the 
	     silence sound ogg file.
	  */
	  if (strlen (gs->str) <= 0)
	    {
	      g_critical (_("%s@%d: failed to parse line: '%s'\n"),
		     __FILE__, __LINE__, read);
	      
	      g_string_free (gs, TRUE);
	      
	      return NULL;
	    }
	  else
	    {
	      /* We still have to construct an absolute path name 
	       */
	      gs =  g_string_prepend (gs,"/sounds/");
	      gs = g_string_prepend (gs, polchemdefctxt->polchemdef->dir);
	      
	      filename = gs->str;
	      g_string_free (gs, FALSE);
	      
	      g_free (line);
	      
	      fclose (cfgp);

	      /*
		debug_printf (("the silence sound is %s\n", filename));
	      */

	      return filename;
	    }
	}
      /* End of 
	 if (read != NULL && strlen (read) > 1)
      */
    }
  /* End of   
     while (read != NULL)
  */
  
  /* Now that we do not need this string anymore, since the file is
   * finished parsing, we can free the memory for reuse of the pointer
   */
  g_free (line);
  
  fclose (cfgp);
  
  return filename;
}

