summary: Terminal server that does PPP and authenticates via RADIUS
name: portslave
version: 2002.10.21
release: 1
copyright: GPL
group: Applications/Communications
buildroot: /tmp/portslave-%{version}

source0: http://www.sourceforge.net/projects/portslave/portslave_%{version}.tar.gz
source1: http://www.sourceforge.net/projects/portslave/ppp-2.4.1.tgz

%description
This package provides a program named portslave which will use AT commands
to answer a modem when it rings. It will then display a login: prompt at
which the user can enter a user-name and password. If the user sends PPP
data then portslave will run it's own pppd instead and authenticate the user
via PAP. When the user-name and password are received they will be verified
via a RADIUS server.

At the end of the call the accounting data will be written to the RADIUS
server.

%prep
%setup0 -q -c -a1 -n portslave-%{version}
cp %{SOURCE1} .

%build
pushd portslave-%{version}
./configure
make
popd

%install
DESTDIR=$RPM_BUILD_ROOT; export DESTDIR
[ -n "`echo $DESTDIR | sed -n 's:^/tmp/[^.].*$:OK:p'`" ] && rm -rf $DESTDIR ||  (echo "Invalid BuildRoot: '$DESTDIR'! Check the spec ..."; exit 1) || exit 1

mkdir -p $DESTDIR/usr/{{s,}bin,lib}
mkdir -p $DESTDIR%{_mandir}/man{1,5,8}
mkdir -p $DESTDIR/etc/{portslave/filters,/rc.d/init.d}

pushd portslave-%{version}
install -c -m 644 pslave.conf	$DESTDIR/etc/portslave/pslave.conf.sample
install -c -m 644 pslave.conf.5	$DESTDIR%{_mandir}/man5
install -c -m 755 src/portslave	$DESTDIR/usr/sbin
install -c -m 644 portslave.8	$DESTDIR%{_mandir}/man8
install -c -o root -g daemon -m 4750 src/ctlportslave $DESTDIR/usr/sbin
install -c -m 644 ctlportslave.1 $DESTDIR%{_mandir}/man1
install -c -m 755 ppp-2.4.1/pppd/pppd $DESTDIR/usr/sbin/pppd-radius
install -c -m 644 ppp-2.4.1/pppd/pppd.8 $DESTDIR%{_mandir}/man8/pppd-radius.8
install -c -m 644 src/libpsr.so $DESTDIR/usr/lib
install -c -m 644 src/libportslave.so $DESTDIR/usr/lib
popd

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
DESTDIR=$RPM_BUILD_ROOT;export DESTDIR;[ -n "$UID" ]&&[ "$UID" -gt 0 ]&&exit 0
[ -n "`echo $DESTDIR | sed -n 's:^/tmp/[^.].*$:OK:p'`" ] && rm -rf $DESTDIR ||  (echo "Invalid BuildRoot: '$DESTDIR'! Check the spec ..."; exit 1) || exit 1

%files
%defattr(-,root,root)
/usr/sbin/portslave
/usr/sbin/ctlportslave
/usr/sbin/pppd-radius
/usr/lib/libpsr.so
/usr/lib/libportslave.so
%{_mandir}/man1/ctlportslave.1*
%{_mandir}/man5/pslave.conf.5*
%{_mandir}/man8/portslave.8*
%{_mandir}/man8/pppd-radius.8*
/etc/portslave/pslave.conf.sample

%dir /etc/portslave
%dir /etc/portslave/filters
%doc portslave-%{version}/docs/*

%changelog
 * Sat Oct 27 2001 Alexandr D. Kanevskiy <kad@asplinux.ru>
 - package for ASPLinux 7.2
 * Tue Jul 10 2001 Andrew McRory <amacc@linuxsys.com>
 - 2001_07-10.1
 - created package for portslave distribution
