#include "policyd.h"


/*
 *
 *
 *                           Policy Daemon
 *
 *  policy daemon is used in conjuction with postfix to combat spam.
 *
 *  Copyright (C) 2004 Cami Sardinha (cami@mweb.co.za)
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the  GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  This program  is  distributed  in the hope that  it will be useful, but
 *  WITHOUT  WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free  Software Foundation Inc.,
 *  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 */


/*
 * function: blacklist_check
 *  purpose: module to check if connecting host/network is blacklisted.
 *   return: 1=yes, 0=no
 */
int
blacklist_check(int fd)
{

  if(DEBUG > 0)
    logmessage("DEBUG: fd: %d checking blacklist\n", fd);

  memset(mysqlquery_array[fd], 0x00, 512);

  /* build up query */
  snprintf(mysqlquery_array[fd], 512,
    "SELECT COUNT(*) FROM blacklist WHERE '%s' LIKE _blacklist", host_array[fd][0]);

  /* run query and handle failure */
  if(db_optquery(fd) == -1)
    return(db_failure(fd, "blacklist"));

  /* blacklisted */
  if(mysql_optarray[fd][0] >= 1)
  {
    if(DEBUG > 0)
    {
      logmessage("DEBUG: fd: %d blacklist found: %s\n", fd, host_array[fd][0]);
      logmessage("DEBUG: fd: %d bypassing other modules\n", fd);
    }

    logmessage("rcpt=%lu, type=blacklist, host=%s (%s), from=%s, to=%s, size=%s\n",
      rcpt_count,
      host_array[fd][0],
      host_array[fd][1],
      triplet_array[fd][1],
      triplet_array[fd][2],
      triplet_array[fd][3]);

    return (1); /* found */
  }

  if(DEBUG)
    logmessage("DEBUG: fd: %d blacklist not found: %s\n", fd, host_array[fd][0]);

  return (0);   /* not found */
}




/*
 * function: blacklist_helo_check
 *  purpose: module to check if connecting mta is using a blacklisted HELO
 *   return: 1=yes, 0=no
 */
int
blacklist_helo_check(int fd)
{
  
  if(DEBUG > 0)
    logmessage("DEBUG: fd: %d checking blacklist helo\n", fd);
	
  memset(mysqlquery_array[fd], 0x00, 512);

  /* save an sql lookup if there is no helo information */
  if(triplet_array[fd][5][0] == 0x00)
    goto notfound;
  
  /* build up query */
  snprintf(mysqlquery_array[fd], 512,
    "SELECT COUNT(_helo) FROM blacklist_helo WHERE _helo='%s'", triplet_array[fd][5]);
  
  /* run query and handle failure */
  if(db_optquery(fd) == -1)
    return(db_failure(fd, "blacklist_helo"));

  /* we have forged helo attempt */
  if(mysql_optarray[fd][0] == 1)
  {
    int expire=0;

    if(DEBUG)
      logmessage("DEBUG: fd: %d blacklisted helo found: %s from: %s\n", fd,
	triplet_array[fd][5], /* helo */
	host_array[fd][0]);   /* host */

    /* store current time */
    timenow=gettime();
      
    /* never auto expire blacklist? */
    if(BLACKLIST_HELO_AUTO_EXPIRE > 0)
     expire=timenow+BLACKLIST_HELO_AUTO_EXPIRE;

    /* blacklist netblock/24 */
    if(BLACKLIST_NETBLOCK == 1)
    {
      /* build up query */
      snprintf(mysqlquery_array[fd], 512,
        "INSERT DELAYED INTO blacklist (_blacklist,_description,_expire) VALUES ('%s.%%','# blacklisted helo: (%s)',%d)",
       triplet_array[fd][0], triplet_array[fd][5], expire);
    } else { /* blacklist host ip */
      /* build up query */
      snprintf(mysqlquery_array[fd], 512,
        "INSERT DELAYED INTO blacklist (_blacklist,_description,_expire) VALUES ('%s','# blacklisted helo: (%s)',%d)",
      host_array[fd][0], triplet_array[fd][5], expire);
    }
    
    /* execute query */
    if(db_doquery(fd) == -1)
      return(db_failure(fd, "blacklist_helo"));
    
    logmessage("rcpt=%lu, type=blacklist_helo, host=%s (%s), from=%s, to=%s, size=%s, helo=%s, expire=%d\n",
      rcpt_count,
      host_array[fd][0],      /* host */
      host_array[fd][1],      /* hostname */
      triplet_array[fd][1],   /* from */
      triplet_array[fd][2],   /* rcpt */
      triplet_array[fd][3],   /* size */
      triplet_array[fd][5],   /* helo */
      expire
    );

    return (1);
  }

notfound:

  if(DEBUG)
    logmessage("DEBUG: fd: %d blacklist helo not found: %s\n", fd, triplet_array[fd][5]);
	
  /* no forged HELO attempt */
  return (0);
}
 
/* EOF */
