#include "policyd.h"


/*
 *
 *
 *                           Policy Daemon
 *
 *  policy daemon is used in conjuction with postfix to combat spam.
 *
 *  Copyright (C) 2004 Cami Sardinha (cami@mweb.co.za)
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the  GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  This program  is  distributed  in the hope that  it will be useful, but
 *  WITHOUT  WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free  Software Foundation Inc.,
 *  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 */


/*
 * function: throttle_check
 *  purpose: throttle users based on SASL info or envelope FROM
 *   return: 0 for new record, 1 for update
 */
int
throttle_check(int fd)
{

  if(DEBUG > 0)
    logmessage("DEBUG: fd: %d checking throttle\n", fd);
  
  memset(mysqlquery_array[fd], 0x00, 512);

  /* store current time */
  timenow=gettime();
    
  /* build up & execute query */
  if(SENDER_THROTTLE_HOST == 1)
  {
    snprintf(mysqlquery_array[fd], 512,
        "SELECT * FROM throttle WHERE _from='%s'", host_array[fd][0]);
  } else if((SENDER_THROTTLE_SASL == 1) && (triplet_array[fd][4][0] != 0x00))  {
      snprintf(mysqlquery_array[fd], 512,
        "SELECT * FROM throttle WHERE _from='%s'", triplet_array[fd][4]);
  } else {
      snprintf(mysqlquery_array[fd], 512,
        "SELECT * FROM throttle WHERE _from='%s'", triplet_array[fd][1]);
  }
  if(db_charquery(fd) == -1)
    return(db_failure(fd, "throttle"));    
  
  /* max messages is disabled in database, fall back to config default */
  if(atol(mysqlchar_array[fd][1]) == 0)
    snprintf(mysqlchar_array[fd][1], sizeof(mysqlchar_array[fd][1]),
	"%d", SENDERMSGLIMIT);

  /* max user quota is disabled in database, fall back to config defaults */
  if(atol(mysqlchar_array[fd][5]) == 0)
    snprintf(mysqlchar_array[fd][5], sizeof(mysqlchar_array[fd][5]),
	"%d", SENDERQUOTALIMIT);
  
  /* max time limit is disabled in database, fall back to config defaults */
  if(atol(mysqlchar_array[fd][6]) == 0)
    snprintf(mysqlchar_array[fd][6], sizeof(mysqlchar_array[fd][6]),
	"%d", SENDERTIMELIMIT);

  /* max message size is disabled in database, fall back to config defaults */
  if(atol(mysqlchar_array[fd][7]) == 0)
    snprintf(mysqlchar_array[fd][7], sizeof(mysqlchar_array[fd][7]),
	"%d", SENDERMSGSIZE);
  
  /* user is not in the database */
  if(strlen(mysqlchar_array[fd][0]) < 2)
  {
    if(SENDER_THROTTLE_HOST == 1)
    {
      logmessage("rcpt=%lu, throttle=new, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=1/%d(1)\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(triplet_array[fd][3])  , /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][1])  /* count_max */
      );
      
      /* build up & execute query */
      snprintf(mysqlquery_array[fd], 512,
        "INSERT DELAYED INTO throttle (_date,_from,_quota_cur) VALUES (%d,'%s',%d)",
          timenow, host_array[fd][0], atoi(triplet_array[fd][3]));
      
    } else if((SENDER_THROTTLE_SASL == 1) && (triplet_array[fd][4][0] != 0x00)) {
      logmessage("rcpt=%lu, throttle=new, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=1/%d(1), sasl_username=\"%s\"\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(triplet_array[fd][3])  , /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][1]), /* count_max */
        triplet_array[fd][4]          /* sasl_username */
      );
      
      /* build up & execute query */
      snprintf(mysqlquery_array[fd], 512,
        "INSERT DELAYED INTO throttle (_date,_from,_quota_cur) VALUES (%d,'%s',%d)",
          timenow, triplet_array[fd][4], atoi(triplet_array[fd][3]));
      
    } else {

      logmessage("rcpt=%lu, throttle=new, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=1/%d(1)\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(triplet_array[fd][3])  , /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][1])  /* count_max */
      );
      
      /* build up & execute query */
      snprintf(mysqlquery_array[fd], 512,
        "INSERT DELAYED INTO throttle (_date,_from,_quota_cur) VALUES (%d,'%s',%d)",
          timenow, triplet_array[fd][1], atoi(triplet_array[fd][3]));
    }

    if(db_doquery(fd) == -1)
      return(db_failure(fd, "throttle"));
    
    /* sender does not exist in the database, insert and allow */
    return (0);
  }
  
  /* if sender is sending a message bigger than allowed, reject */
  if(atol(triplet_array[fd][3]) >= atol(mysqlchar_array[fd][7]))
  {
    
    if((SENDER_THROTTLE_SASL == 1) && (triplet_array[fd][4][0] != 0x00))
    {
      logmessage("rcpt=%lu, throttle=abuse, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=%d/%d(%d), sasl_username:%s\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][2]), /* count_cur */
        atol(mysqlchar_array[fd][1]), /* count_max */
        atol(mysqlchar_array[fd][8]), /* count_tot */
        triplet_array[fd][4]          /* sasl_username */
      );
      
    } else {
      
      logmessage("rcpt=%lu, throttle=abuse, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=%d/%d(%d)\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][2]), /* count_cur */
        atol(mysqlchar_array[fd][1]),  /* count_max */
        atol(mysqlchar_array[fd][8])  /* count_tot */
      );
    }
    
    return (-3);
  }
      
  /* if time has expired, clear quota for size+message count */
  if(timenow > (atol(mysqlchar_array[fd][6])+atol(mysqlchar_array[fd][3])))
  {
    
    if(SENDER_THROTTLE_HOST == 1)
    {
      
      logmessage("rcpt=%lu, throttle=clear, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=0/%d(%d)\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][1]), /* count_max */
        atol(mysqlchar_array[fd][8]) /* count_tot */
      );
      
      snprintf(mysqlquery_array[fd], 512,
        "UPDATE throttle SET _count_cur='1',_count_tot=_count_tot+1,_date='%d',_quota_cur='%d' WHERE _from='%s'",
        timenow, atoi(triplet_array[fd][3]), host_array[fd][0]);
      
    } else if((SENDER_THROTTLE_SASL == 1) && (triplet_array[fd][4][0] != 0x00)) {
      
      logmessage("rcpt=%lu, throttle=clear, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=0/%d(%d), sasl_username=%s\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][1]), /* count_max */
        atol(mysqlchar_array[fd][8]), /* count_tot */
        triplet_array[fd][4]          /* sasl_username */
      );
      
      snprintf(mysqlquery_array[fd], 512,
        "UPDATE throttle SET _count_cur='1',_count_tot=_count_tot+1,_date='%d',_quota_cur='%d' WHERE _from='%s'",
        timenow, atoi(triplet_array[fd][3]), triplet_array[fd][4]);
      
    } else {

      logmessage("rcpt=%lu, throttle=clear, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=0/%d(%d)\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][1]), /* count_max */
        atol(mysqlchar_array[fd][8])  /* count_tot */
      );
      snprintf(mysqlquery_array[fd], 512,
        "UPDATE throttle SET _count_cur='1',_count_tot=_count_tot+1,_date='%d',_quota_cur='%d' WHERE _from='%s'",
        timenow, atoi(triplet_array[fd][3]), triplet_array[fd][1]);
    }
    
    if(db_doquery(fd) == -1)
      return(db_failure(fd, "throttle"));

    /* counter reset because of expiry, allow mail */
    return (0);
  }
  
  /* if the sender is past his quota and the timeout has not expired */
  /* then reject the message */
  if(atol(mysqlchar_array[fd][2]) >= atol(mysqlchar_array[fd][1]) ||
     atol(mysqlchar_array[fd][4]) >= atol(mysqlchar_array[fd][5]))
  {
    if(SENDER_THROTTLE_HOST == 1)
    {
      logmessage("rcpt=%lu, throttle=abuse, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=%d/%d(%d)\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][2]), /* count_cur */
        atol(mysqlchar_array[fd][1]), /* count_max */
        atol(mysqlchar_array[fd][8])  /* count_tot */
      );
      
    } else if((SENDER_THROTTLE_SASL == 1) && (triplet_array[fd][4][0] != 0x00)) {
      logmessage("rcpt=%lu, throttle=abuse, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=%d/%d(%d), sasl_username=%s\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][2]), /* count_cur */
        atol(mysqlchar_array[fd][1]), /* count_max */
        atol(mysqlchar_array[fd][8]), /* count_tot */
        triplet_array[fd][4]          /* sasl_username */
      );
    } else {
      
      logmessage("rcpt=%lu, throttle=abuse, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=%d/%d(%d)\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][2]), /* count_cur */
        atol(mysqlchar_array[fd][1]), /* count_max */
        atol(mysqlchar_array[fd][8])  /* count_tot */
      );
    }
    
    return (-5);
  }

  /* if the sender has not reached his quota, increase count */
  if(atol(mysqlchar_array[fd][2]) < atol(mysqlchar_array[fd][1]))
  {

    if(SENDER_THROTTLE_HOST == 1)
    {

      logmessage("rcpt=%lu, throttle=update, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=%d/%d(%d)\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4])+atol(triplet_array[fd][3]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][2])+1, /* count_cur */
        atol(mysqlchar_array[fd][1]), /* count_max */
        atol(mysqlchar_array[fd][8])  /* count_tot */
      );
      
      snprintf(mysqlquery_array[fd], 512,
        "UPDATE throttle SET _count_cur=_count_cur+1,_count_tot=_count_tot+1,_quota_cur=_quota_cur+'%ld' WHERE _from='%s'",
        atol(triplet_array[fd][3]), host_array[fd][0]);

    } else if((SENDER_THROTTLE_SASL == 1) && (triplet_array[fd][4][0] != 0x00)) {

      logmessage("rcpt=%lu, throttle=update, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=%d/%d(%d), sasl_username=%s\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4])+atol(triplet_array[fd][3]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][2])+1, /* count_cur */
        atol(mysqlchar_array[fd][1]), /* count_max */
        atol(mysqlchar_array[fd][8]), /* count_tot */
        triplet_array[fd][4]          /* sasl_username */
      );
      
      snprintf(mysqlquery_array[fd], 512,
        "UPDATE throttle SET _count_cur=_count_cur+1,_count_tot=_count_tot+1,_quota_cur=_quota_cur+'%ld' WHERE _from='%s'",
        atol(triplet_array[fd][3]), triplet_array[fd][4]);
    
    } else {
      
      logmessage("rcpt=%lu, throttle=update, host=%s, from=%s, to=%s, size=%d/%d, quota=%d/%d, count=%d/%d(%d)\n",
	rcpt_count,
        host_array[fd][0],            /* host */
        triplet_array[fd][1],         /* from */
        triplet_array[fd][2],         /* to   */
        atol(triplet_array[fd][3]),   /* size_cur */
        atol(mysqlchar_array[fd][7]), /* size_max */
        atol(mysqlchar_array[fd][4])+atol(triplet_array[fd][3]), /* quota_cur */
        atol(mysqlchar_array[fd][5]), /* quota_max */
        atol(mysqlchar_array[fd][2])+1, /* count_cur */
        atol(mysqlchar_array[fd][1]),  /* count_max */
        atol(mysqlchar_array[fd][8])  /* count_tot */
      );
      
      snprintf(mysqlquery_array[fd], 512,
        "UPDATE throttle SET _count_cur=_count_cur+1,_count_tot=_count_tot+1,_quota_cur=_quota_cur+'%ld' WHERE _from='%s'",
        atol(triplet_array[fd][3]), triplet_array[fd][1]);

    }

    /* build up & execute query */
    if(db_doquery(fd) == -1)
      return(db_failure(fd, "throttle"));

    return (0);
  }

  return (0); /* never reached */
}
 
/* EOF */
