#include "policyd.h"


/*
 *
 *
 *                           Policy Daemon
 *
 *  policy daemon is used in conjuction with postfix to combat spam.
 *
 *  Copyright (C) 2004 Cami Sardinha (cami@mweb.co.za)
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the  GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  This program  is  distributed  in the hope that  it will be useful, but
 *  WITHOUT  WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free  Software Foundation Inc.,
 *  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 */


/*
 * function: whitelist_check
 *  purpose: check if the connecting host is whitelisted
 *   return: 1=yes, 0=no
 */
int
whitelist_check(int fd)
{
  
  if(DEBUG > 0)
    logmessage("DEBUG: fd: %d checking whitelist\n", fd);

  memset(mysqlquery_array[fd], 0x00, 512);
  
  /* build up query */
  snprintf(mysqlquery_array[fd], 512,
    "SELECT COUNT(*) FROM whitelist WHERE '%s' LIKE _whitelist", host_array[fd][0]);
  
  /* run query and handle failure */
  if(db_optquery(fd) == -1)
    return(db_failure(fd, "whitelist"));

  /* whitelist null senders */
  if(WHITELISTNULL == 1)
    if(strlen(triplet_array[fd][1]) == 2)
      mysql_optarray[fd][0]=1;
  
  /* whitelisted */
  if(mysql_optarray[fd][0] >= 1)
  {
    if(DEBUG > 0)
    {
      logmessage("DEBUG: fd: %d whitelist found: %s\n", fd, host_array[fd][0]);
      logmessage("DEBUG: fd: %d bypassing other modules\n", fd);
    }

    logmessage("rcpt=%lu, type=whitelist, host=%s (%s), from=%s, to=%s, size=%s\n",
      rcpt_count,
      host_array[fd][0],
      host_array[fd][1],
      triplet_array[fd][1],
      triplet_array[fd][2],
      triplet_array[fd][3]);

    return (1); /* found */
  }

  if(DEBUG)
    logmessage("DEBUG: fd: %d whitelist not found: %s\n", fd, host_array[fd][0]);
	
  return (0);   /* not found */
}
 
/* EOF */
