/*                              
Service_Calendar.cc
*/

#include "Service_Calendar.h"
#include "DateTimeUtils.h"

extern Language *L;
extern Configuration *Conf;
extern CCLIENT *cclient;
extern Skin *skin;

bool Service_Calendar_Initialized = false;
int workingYear, workingMonth, workingDay;
bool BeginWeekOnSunday = false;

class HTMLPages: public HTMLBasic
  {
  private:
    void PrintStatusLine_Calendar (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname);
    void BotoneraComun_Calendar (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo);
  public:
    void PrintCalendarYearShow (TProgData *pd);    
    void PrintCalendarMonthShow (TProgData *pd);    
    void PrintCalendarWeekShow (TProgData *pd);
    void PrintCalendarDayShow (TProgData *pd);    
    void PrintCalendarEventsShow (TProgData *pd);        
    };

void HTMLPages::PrintStatusLine_Calendar (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname)
  {
  WRITE ("<TABLE width=\"100%%\">\n<TR>\n");
  if (FileExists (FILE_FOR_NO_ACCEPT_NEW_CONNS) == true)
    {
    TBuffer amsg;
    GetBufferFromFile (FILE_FOR_NO_ACCEPT_NEW_CONNS, amsg, CMAXBUFFER);
    WRITE ("<TD align=left><B><FONT color=\"#FF0000\"><BLINK>%s</BLINK></FONT></B></TD>\n<TD align=right><B><FONT size=2 color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
              amsg, skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
              L->get(L_USER), user, uo->getImapServer(), 
              mailboxname);
    }
  else
    {
    if (cclient->getError () == false)
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             uo->getStatusLine(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }
    else
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             cclient->getErrorString(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }  
    }
  
  //Only is seen in IE4+/N6+
  if ((displayClock == true) && (uo->get_use_javascript() == true) && (uo->getShowClock() == true))
    {        
    WRITE ("<TD width=\"1%%\" align=right>");  
    JavaScript (DEF_JavaScriptIDClock);    
    JavaScript (DEF_JavaScriptClock);
    WRITE ("</TD>"); 
    }

  WRITE ("\n</TR></TABLE>\n");
  }

void HTMLPages::BotoneraComun_Calendar (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  long actualpos, totalmsgs;
  int validator, pageid;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId ();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));
    
      //BUTTON BACK  
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");        
      WRITE ("%s", uo->getLastStringCmd(cmdactual, lang, connid, true));                   
      Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize()); 
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
      WRITE ("</A>");
      EndTD();   

      //SPACE 
      EmptyCellx2();

      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   

      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      switch (cmdactual)
        {
        case CMD_CALENDAR_MONTH_SHOW: 
        case CMD_CALENDAR_WEEK_SHOW:         
        case CMD_CALENDAR_DAY_SHOW:         
        case CMD_CALENDAR_EVENTS_SHOW:  
             {       
             WRITE ("<A HREF=\"%s/%s/help/calendar_show/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CALENDAR, lang, user, connid, validator, pageid, cmdactual); break; 
             }
        }
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());  
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      
      //SPACE 
      EmptyCellx2();     
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD(); 
    EndTR();
  EndTable ();  
  PrintStatusLine_Calendar (user, uo, true, cclient->getMailboxName());
  }

//retrieve the url for the Service icon
const char *GetService_Calendar_ICO_URL (void)
  {
  return skin->getI(L_CALENDAR);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_Calendar_ICO_ALT (void)
  {
  return L->get(L_CALENDAR);
  }

//Retrieve the Service name
const char *GetService_Calendar_NAME (void)
  {
  return L->get(L_CALENDAR);
  }

//Retrieve the Service Description
const char *GetService_Calendar_DESCRIPTION (void)
  {
  return L->get(L_CALENDAR_DESCRIPTION);
  }

//Entry point to service init
bool DoService_Calendar_BEGIN (TProgData *pd)
  {
  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  
  if (Service_Calendar_Initialized == true) {return true;}
  Service_Calendar_Initialized = false;
  LOG ("Initializating Service Calendar for user=%s", pd->username);      

  BeginWeekOnSunday = false;
  workingYear  = CurrentYear ();
  workingMonth = CurrentMonth ();
  workingDay   = CurrentDay ();
    
  Service_Calendar_Initialized = true;    
  return true;
  }

//Entry point to service end
bool DoService_Calendar_END (TProgData *pd)
  {
  if (Service_Calendar_Initialized == false) {return true;}
  
  Service_Calendar_Initialized = false;
    
  return true;
  }

//Entry point to execute a service command
bool DoService_Calendar_CMD (TProgData *pd)
  {
  HTMLPages *html;
  int cmd;

  html = (HTMLPages *)pd->html;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        

  cmd = pd->cmd;
                  
  switch (pd->cmd)
    {
    case (CMD_CALENDAR_YEAR_SHOW):   {pd->uo->InitStatusLine (); html->PrintCalendarYearShow (pd); break;}       
    case (CMD_CALENDAR_MONTH_SHOW):  {pd->uo->InitStatusLine (); html->PrintCalendarMonthShow (pd); break;}      
    case (CMD_CALENDAR_WEEK_SHOW):   {pd->uo->InitStatusLine (); html->PrintCalendarWeekShow (pd); break;}       
    case (CMD_CALENDAR_DAY_SHOW):    {pd->uo->InitStatusLine (); html->PrintCalendarDayShow (pd); break;}      
    case (CMD_CALENDAR_EVENTS_SHOW): {pd->uo->InitStatusLine (); html->PrintCalendarEventsShow (pd); break;}      
    default: 
      {    
      //pd->html->dumpFile (pd->envfile, "TEXT/PLAIN");
      LOG ("ERROR: Service_Calendar: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }         
    }
  return false;  
  }  

void HTMLPages::PrintCalendarMonthShow (TProgData *pd)    
  {
  }
  
void HTMLPages::PrintCalendarWeekShow (TProgData *pd)
  {
  }
  
void HTMLPages::PrintCalendarDayShow (TProgData *pd)    
  {
  }
  
void HTMLPages::PrintCalendarEventsShow (TProgData *pd)        
  {
  }

void HTMLPages::PrintCalendarYearShow (TProgData *pd)
  {
  long jul;
  int dow, begday;
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_CALENDAR_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  
  BotoneraComun_Calendar (CMD_CALENDAR_WEEK_SHOW, pd->stlang, pd->username, pd->connid, pd->uo);  

  WRITE ("<CENTER>%s %d</CENTER>\n", L->get(L_CALENDAR), CurrentYear());

  BeginFormPost ("PrintCalendarChangeShow", PATH_CGI);
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "calendar_do");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_CALENDAR_WEEK_SHOW);    
  BR();

  if (BeginWeekOnSunday == false) begday = 1; else begday = 0;
  WRITE ("<SMALL>\n");
  WRITE ("<TABLE WIDTH=100%%>\n");
  for (int i = 0; i < NUMBER_MONTHS; ++i)
    {
    if ((i == 0) || (i == 4) || (i == 8)) WRITE ("<TR>\n");
    WRITE ("<TD>\n");    
    WRITE ("<CENTER><B>%s</B><CENTER></BR>\n", getLongMonth(i)); 
    WRITE ("<TABLE>\n");  
    WRITE ("<TR>"); for (int j = 0; j < NUMBER_DAYSFORWEEK; ++j) {WRITE ("<TD><B>%s</B></TD>", getShortDay2(j + begday));} WRITE ("</TR>\n");
    
    WRITE ("<TR>\n");
    jul = GregorianToJulian (0, i, workingYear);
    dow = DayOfWeek (jul);
    WRITE ("--%d--", dow);
    /*
    for (int j = 0; j < DaysOfMonth(i, workingYear) + dow; ++j) 
      {
      if (j < dow) {WRITE("<TD&nbsp;</TD>\n");} else
        {
        if (IsMultiplo(j + begday, 7))
          {
          WRITE ("<TD align=right>%d</TD></TR><TR>", j - dow + 1);
          }
        else
          {   
          WRITE ("<TD align=right>%d</TD>", j - dow + 1); 
          }
        }
      }
    */  
    WRITE ("</TR>\n");
      
    WRITE ("</TABLE>\n");                          
    if ((i == 3) || (i == 7) || (i == 11)) WRITE ("</TR>\n");
    }
  EndTable();
  WRITE ("</SMALL>\n");
  EndForm ();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }
                                                       
  
  
  
