/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include "process.h"

void process_audio(float *channels, int num_channels, int processing) {
	float f = 0.0;

	switch (processing) {
	case PROCESS_NONE:
		break;
	case PROCESS_OOPS:
		for (int i = 1; i < num_channels; i++) {
			channels[i - 1] = channels[i] = channels[i - 1] - channels[i];
		}
		break;
	case PROCESS_MONO:
		for (int i = 0; i < num_channels; i++) {
			f += channels[i];
		}
		f /= num_channels;
		for (int i = 0; i < num_channels; i++) {
			channels[i] = f;
		}
		break;
	case PROCESS_PHASE:
		for (int i = 1; i < num_channels; i += 2) {
			channels[i] = -channels[i];
		}
		break;
	case PROCESS_LEFT:
		for (int i = 1; i < num_channels; i += 2) {
			channels[i] = channels[i - 1];
		}
		break;
	case PROCESS_RIGHT:
		for (int i = 1; i < num_channels; i += 2) {
			channels[i - 1] = channels[i];
		}
		break;
	case PROCESS_SWAP:
		for (int i = 1; i < num_channels; i += 2) {
			f = channels[i];
			channels[i] = channels[i - 1];
			channels[i - 1] = f;
		}
		break;
	}
}
