#ifndef	_PPXP_DEVICE_H
#define	_PPXP_DEVICE_H

#define	OPEN_AGAIN	-2
#define	OPEN_FAILED	-1
#define	OPEN_SUCCESS	0
#define	OPEN_DELAYED	1

struct device_s {
    struct device_s *next;
    bool_t (*probe)();
    int (*open)();
    int (*write)(int, u_char *, int, u_int16_t);
    int (*read)();
    void (*close)();
    int (*check)();
#if 0
    bool_t keep;
#endif
};

struct device_s *GetDevOp();

extern int AsyncWrite(int, u_char *, int, u_int16_t);
extern int AsyncRead(int);
extern void Close();
extern void RegisterDevice();

extern int (*DevOpen)();
extern int (*DevWrite)(int, u_char *, int, u_int16_t);
extern int (*DevRead)();
extern void (*DevClose)();
extern int (*DevCheck)();

extern struct device_s *devOp;

#endif	/* _PPXP_DEVICE_H */
