#ifndef _OlaP_h_
#define _OlaP_h_

/* OlaP.h
 *
 * Copyright (C) 2007-2008 Ola Söder
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * os 20080529 Initial release
 */

/////////////////////////////////////////
// Macros                              //
/////////////////////////////////////////

#define OlaSWAP(TYPE, X, Y) {TYPE temp = X; X = Y; Y = temp;}
#define OlaMAX(x,y) ((x) > (y) ? (x) : (y))
#define OlaMIN(x,y) ((x) < (y) ? (x) : (y))
#define OlaSQUARE(x) ((x) * (x))			

/////////////////////////////////////////
// DEBUG                               //
/////////////////////////////////////////

#ifdef _DEBUG
    #include <assert.h>
    #include <stdio.h>
    #define TRACE(...) printf("%s:%s> ", __FILE__, __FUNCTION__); printf(__VA_ARGS__)
    #define ASSERT(X) assert((X))
#else
    #define TRACE(...)    
    #define ASSERT(X)  
#endif

/////////////////////////////////////////
// Misc defines                        //
/////////////////////////////////////////

#define MINFLOAT 0.0000000000000000000001

#endif /* _Misc_h_ */
