/* RBM_extensions.cpp
 *
 * Copyright (C) 2016 David Weenink
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This code is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this work. If not, see <http://www.gnu.org/licenses/>.
 */

#include "RBM_extensions.h"
#include "NUM2.h"

autoActivationList RBM_PatternList_to_ActivationList (RBM me, PatternList thee) {
	try {
		autoActivationList activations = ActivationList_create (thy ny, my numberOfOutputNodes);
		for (long ipattern = 1; ipattern <= thy ny; ipattern ++) {
			RBM_PatternList_applyToInput (me, thee, ipattern);
			RBM_spreadUp (me);
			RBM_sampleOutput (me);
			NUMvector_copyElements <double> (my outputActivities, activations -> z [ipattern], 1, my numberOfOutputNodes);
		}
		return activations;
	} catch (MelderError) {
		Melder_throw (me, thee, U"No ActivationList created.");
	}
}

/* End of file RBM_extensions.cpp */

