/* readahead.c - read in advance a list of files, adding them to the page cache
 *
 * Copyright (C) 2005  Behdad Esfahbod
 * Copyright (C) 2005  Ziga Mahkovec  <ziga.mahkovec@klika.si>
 * Based on a previous version by Arjan van de Ven  <arjanv@redhat.com>
 *
 * This file is part of preload.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301  USA
 */

#include "common.h"
#include "readahead.h"
#include "log.h"
#include "conf.h"


/* Compare files by path. */
static int
map_path_compare (const preload_map_t **pa, const preload_map_t **pb)
{
  const preload_map_t *a = *pa, *b = *pb;
  int i;
  
  i = strcmp(a->path, a->path);
  if (!i) /* same file */
    i = a->offset - b->offset;
  if (!i) /* same offset?! */
    i = b->length - a->length;

  return i;
}



static void
process_file(preload_map_t *file)
{
  int		fd = -1;

  fd = open(file->path, O_RDONLY);
  if (fd < 0)
    return;
  
  readahead(fd, file->offset, file->length);

  close (fd);
}

void
preload_readahead (preload_map_t **files, int file_count)
{
  int i;

  /* Sorting by path should offer least directory block seeking. */
  qsort(files, file_count, sizeof(*files), (GCompareFunc)map_path_compare);

  for (i=0; i<file_count; i++)
    process_file(files[i]);
}
