/* Copyright (C) 1999-2000 Bernhard Trummer
 * Copyright (C) 2003      Benjamin Drieu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: node.h,v $
 * Revision 1.5  2003/04/24 14:07:10  benj
 * Adding Debian stuff
 * Some update with autotool-dev
 *
 * Revision 1.4  2003/03/06 14:54:24  benj
 * Update copyrigth where it is necessary
 *
 * Revision 1.3  2003/02/18 12:56:50  bdrieu
 * - Update to make prestimel compile with g++-3.2
 * - Use Magick++ instead of Magick
 *
 * Revision 1.2  2001/09/02 12:48:00  slash
 * Make use of AM_PATH_XML and AM_PATH_XML2 in configure.in
 *
 * Revision 1.1.1.1  2001/01/30 18:36:40  slash
 * Initial release.
 *
 */

#ifndef NODE_H
#define NODE_H

#include <libxml/tree.h>

#include <vector>


//---------------------------------------------------------------------------
/**
 * This base-class provides a common interface for all nodes.
 * This interface contains methods to write the node to a HTML-,
 * a LaTeX- or a XML-file.
 */
class Node { 
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the node.
     */
    Node();

    //-----------------------------------------------------------------------
    /**
     * Destructor
     */
    virtual ~Node();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     * This method must be overloaded by all derivated classes.
     *
     * @param parameter An integer-parameter which may have a special meaning
     *                  for each derivated class.
     */
    virtual void writeHTML(int parameter = 0) const = 0;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     * This method must be overloaded by all derivated classes.
     */
    virtual void writeLaTeX() const = 0;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     * This method must be overloaded by all derivated classes.
     */       
    virtual void writeXML() const = 0;

    //-----------------------------------------------------------------------
    /**
     * This method returns the number of characters of the stored text.
     * Note, that some derivated Nodes don't store any text.
     * In this case, this method is called recursively on the child-nodes.
     *
     * @return The length of the stored text.
     */
    virtual unsigned int getLength() const;


  protected:

    //-----------------------------------------------------------------------
    /**
     * An array of pointers to all child-nodes.
     */
    std::vector<Node*> child_nodes_;
};

#endif //NODE_H
