//
//  PRConvolve55.m
//  PRICE
//
//  Created by Riccardo Mottola on Sat Jan 18 2003.
//  Copyright (c) 2003 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import <math.h>
#import <limits.h>

#import "PRConvolve55.h"
#import "PRGrayscaleFilter.h"

@implementation PRConvolve55

- (NSImage *)convolveImage:(NSImage *)srcImage :(int[5][5])convMat :(int)offset :(float)scale :(BOOL)autoScale
{
    NSBitmapImageRep *srcImageRep;
    NSImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y; /* image scanning variables */
    int i, j; /* convolve matrix scanning */
    unsigned char *srcData;
    unsigned char *destData;
    int bytesPerPixel;
    int convSum;
    float normalizeFactor;
    int minVal, maxVal;
    
    NSLog(@"inside %@.%@", [self className], NSStringFromSelector(_cmd));
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    if ([srcImageRep hasAlpha])
    {
        if ([srcImageRep samplesPerPixel] == 2)
        {
            printf("Grayscale image\n");
        }
        else
        {
            printf("Color image\n");
            return srcImage;
        }
    }
    else
    {
        if ([srcImageRep samplesPerPixel] == 1)
        {
            printf("Grayscale image\n");
        }
        else
        {
            PRGrayscaleFilter *grayFilter;
            printf("Color image\n");
            grayFilter = [[PRGrayscaleFilter alloc] init];
            srcImage = [grayFilter filterImage:srcImage];
            [grayFilter release];
            NSLog (@"done greyscale converting");
            /* we reget previous information that is no longer valid */
            /* get source image representation and associated information */
            srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
            bytesPerPixel = [srcImageRep bitsPerPixel] /8;
        }
    }
    
    /* allocate destination image and its representation */
    destImage = [[NSImage alloc] initWithSize:NSMakeSize(w, h)];
    destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    
    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    

    if (autoScale)
    {
        minVal = INT_MAX;
        maxVal = INT_MIN;
        
        /* calibrate output range */
        for (y = 0 + 2; y < h - 3; y++)
            for (x = 0 + 2; x < w - 3; x++)
            {
                convSum = 0;
                for (i = -2; i <= 2; i++)
                    for (j = -2; j <= 2; j++)
                        convSum += convMat[i+2][j+2] * (int)srcData[(y-j) * w + (x-i)];
                if (convSum > maxVal)
                    maxVal = convSum;
                if (convSum < minVal)
                    minVal = convSum;
            }
        printf("Max %d, min %d\n", maxVal, minVal);
        normalizeFactor = (float)fabs(maxVal -minVal)/(float)UCHAR_MAX;
        printf("normalize factor: %f\n", normalizeFactor);
        offset = -minVal;
        scale = normalizeFactor;
    }
    
    printf("offset: %d, scale:%f\n", offset, scale);
    
    /* execute the actual filtering */
    /* the borders */
    for (y = 0; y < 0 + 2; y++)
    {
        /* top left corner */     
        for (x = 0; x < 0 + 2; x++)
        {
            convSum = 0;
            for (i = -2; i <= -1 - y; i++)
            {
                for (j = -2; j <= -1 - x; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i-1)) * w + (x+(-j-1))];
                for (j = 0 - x; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i-1)) * w + (x+j)];
            }
            for (i = 0 - y; i <= 2; i++)
            {
                for (j = -2; j <= -1 - x; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+(-j-1))];
                for (j = 0 - x; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+j)];
            }
            convSum += offset;
            convSum = (int)rint((float)convSum / scale);         
            if (convSum < 0)
                convSum = 0;
            if (convSum > UCHAR_MAX)
                convSum = UCHAR_MAX;  
            destData[y*w + x] = (unsigned char)convSum;
        }
        /* top band */
        for (x = 0 + 2; x < w - 3; x++)
        {
            convSum = 0;
            for (i = -2; i <= -1 - y; i++)
                for (j = -2; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i-1)) * w + (x+j)];
            for (i = 0 - y; i <= 2; i++)
                for (j = -2; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+j)];
            convSum += offset;
            convSum = (int)rint((float)convSum / scale);         
            if (convSum < 0)
                convSum = 0;
            if (convSum > UCHAR_MAX)
                convSum = UCHAR_MAX;  
            destData[y*w + x] = (unsigned char)convSum;
        }
        /* top right corner */     
        for (x = w - 3; x < w; x++)
        {
            convSum = 0;
            for (i = -2; i <= -1 - y; i++)
            {
                for (j = -2; j <= -1 - (x - w); j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i-1)) * w + (x+j)];
                for (j = 0 - (x - w); j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i-1)) * w + (x+(-j+1))];
            }
            for (i = 0 - y; i <= 2; i++)
            {
                for (j = -2; j <= -1 - (x - w); j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+j)];
                for (j = 0 - (x - w); j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+(-j+1))];
            }
            convSum += offset;
            convSum = (int)rint((float)convSum / scale);         
            if (convSum < 0)
                convSum = 0;
            if (convSum > UCHAR_MAX)
                convSum = UCHAR_MAX;  
            destData[y*w + x] = (unsigned char)convSum;
        }
    }
    for (y = 0 + 2; y < h - 3; y++)
    {
        /* left band */
        for (x = 0; x < 0 + 2; x++)
        {
            convSum = 0;
            for (i = -2; i <= 2; i++)
            {
                for (j = -2; j <= -1 - x; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+(-j-1))];
                for (j = 0 - x; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+j)];
            }
            convSum += offset;
            convSum = (int)rint((float)convSum / scale);         
            if (convSum < 0)
                convSum = 0;
            if (convSum > UCHAR_MAX)
                convSum = UCHAR_MAX;  
            destData[y*w + x] = (unsigned char)convSum;
        }
        /* right band */
        for (x = w - 3; x < w; x++)
        {
            convSum = 0;
            for (i = -2; i <= 2; i++)
            {
                for (j = -2; j <= -1 - (x - w); j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+j)];
                for (j = 0 - (x - w); j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+(-j+1))];;
            }
            convSum += offset;
            convSum = (int)rint((float)convSum / scale);         
            if (convSum < 0)
                convSum = 0;
            if (convSum > UCHAR_MAX)
                convSum = UCHAR_MAX;  
            destData[y*w + x] = (unsigned char)convSum;
        }
    }
    for (y = h - 3; y < h; y++)
    {
        /* bottom left corner */     
        for (x = 0; x < 0 + 2; x++)
        {
            convSum = 0;
            for (i = -2; i <= -1 - (y - h); i++)
            {
                for (j = -2; j <= -1 - x; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+(-j-1))];
                for (j = 0 - x; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+j)];
            }
            for (i = 0 - (y - h); i <= 2; i++)
            {
                for (j = -2; j <= -1 - x; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i+1)) * w + (x+(-j-1))];
                for (j = 0 - x; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i+1)) * w + (x+j)];
            }
            convSum += offset;
            convSum = (int)rint((float)convSum / scale);         
            if (convSum < 0)
                convSum = 0;
            if (convSum > UCHAR_MAX)
                convSum = UCHAR_MAX;  
            destData[y*w + x] = (unsigned char)convSum;
        }
        /* bottom band */
        for (x = 0 + 2; x < w - 3; x++)
        {
            convSum = 0;
            for (i = -2; i <= -1 - (y - h); i++)
                for (j = -2; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+j)];
            for (i = 0 - (y - h); i <= 2; i++)
                for (j = -2; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i+1)) * w + (x+j)];
            convSum += offset;
            convSum = (int)rint((float)convSum / scale);         
            if (convSum < 0)
                convSum = 0;
            if (convSum > UCHAR_MAX)
                convSum = UCHAR_MAX;  
            destData[y*w + x] = (unsigned char)convSum;
        }
        /* bottom right corner */     
        for (x = w - 3; x < w; x++)
        {
            convSum = 0;
            for (i = -2; i <= -1 - (y - h); i++)
            {
                for (j = -2; j <= -1 - (x - w); j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+j)];
                for (j = 0 - (x - w); j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+(-j+1))];
            }
            for (i = 0 - (y - h); i <= 2; i++)
            {
                for (j = -2; j <= -1 - (x - w); j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i+1)) * w + (x+j)];
                for (j = 0 - (x - w); j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+(-i+1)) * w + (x+(-j+1))];
            }
            convSum += offset;
            convSum = (int)rint((float)convSum / scale);         
            if (convSum < 0)
                convSum = 0;
            if (convSum > UCHAR_MAX)
                convSum = UCHAR_MAX;  
            destData[y*w + x] = (unsigned char)convSum;
        }
    }
    /* the core */
    for (y = 0 + 2; y < h - 3; y++)
        for (x = 0 + 2; x < w - 3; x++)
        {
            convSum = 0;
            for (i = -2; i <= 2; i++)
                for (j = -2; j <= 2; j++)
                    convSum += convMat[i+2][j+2] * (int)srcData[(y+i) * w + (x+j)];
            convSum += offset;
            convSum = (int)rint((float)convSum / scale);         
            if (convSum < 0)
                convSum = 0;
            if (convSum > UCHAR_MAX)
                convSum = UCHAR_MAX;  
            destData[y*w + x] = (unsigned char)convSum;
        }

    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}


@end
