%define ruby_libdir %(ruby -rrbconfig -e 'puts Config::CONFIG["rubylibdir"]')
%define name    prime-dict
%define version 0.8.3
%define release 1

Summary: PRIME - a Japanese PRedictive Input Method Editor (dictionary)
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
URL: http://taiyaki.org/prime
Source: http://taiyaki.org/prime/src/%{name}-%{version}.tar.gz
Group: Applications/System
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildArch: noarch
Requires: ruby
BuildRequires: ruby

%description
PRIME predicts user's input words using the knowledge of natural
language and the history of user's operations, and reduces the
cost of typing by the user.  For example, if a user wants to input
"application" and types "ap" as the beginning characters of the word,
PRIME might predict some candidate words like "apple", "application",
"appointment", etc...  And then the user can input "application"
easily by selecting the word from the candidate words by PRIME.

%prep
rm -rf %{buildroot}

%setup -q

%build
%configure
make

%install
make prefix=%{buildroot}%{_prefix} \
PRIME_DICT_DIR=%{buildroot}%{_datadir}/prime/dict \
rubydir=%{buildroot}%{ruby_libdir} \
primedotfilesdir=%{buildroot}%{_docdir}/%{name}/examples \
install

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{_datadir}/prime/dict
%{_libdir}/ruby/*/*
%doc AUTHORS COPYING NEWS README ChangeLog

%changelog
* Mon Nov  3 2003 Masaki Yatsu <yatsu@digital-genes.com>
- (0.6.0-1)
- initial version
