(defvar prime-pat "")
(make-variable-buffer-local 'prime-pat)
(defvar prime-start-pat "" "convert-region $B$r%-%c%s%;%k$7$?;~$K85$KLa$9J8;zNs(B")
(make-variable-buffer-local 'prime-start-pat)
(defvar prime-pat-for-undo "")
(make-variable-buffer-local 'prime-pat-for-undo)

(defvar	prime-cands nil)
(make-variable-buffer-local 'prime-cands)
(defvar	prime-cands-for-undo nil)
(make-variable-buffer-local 'prime-cands-for-undo)

(defvar prime-context nil) ; $B8!:w8uJd$N%3%s%F%-%9%H(B. $B<g$KA02sF~NOC18l(B
(make-variable-buffer-local 'prime-context)
(defvar prime-context-for-undo nil)
(make-variable-buffer-local 'prime-context-for-undo)

(defvar	prime-nth-cand 0) ; $B$$$/$D$a$N8uJd$rA*Br$7$F$$$k$+(B
(make-variable-buffer-local 'prime-nth-cand)
(defvar	prime-nth-cand-for-undo 0)
(make-variable-buffer-local 'prime-nth-cand-for-undo)

(defvar prime-conv-mode-for-undo nil)
(make-variable-buffer-local 'prime-conv-mode-for-undo)

;; $BFbItJQ?t$NDj5A(B.
;(defvar	prime-pat "") ; $B8!:w%Q%?%s(B
;(make-variable-buffer-local 'prime-pat)
(defvar	prime-prev-pattern nil 
  "prime-pat $B$H$3$NCM$,F1$8$J$i$P%-%c%C%7%e$7$?8uJd$rMxMQ$9$k(B.")
(make-variable-buffer-local 'prime-prev-pattern)
(defvar	prime-next-pattern "")		; $B8!:w%Q%?%s(B
(make-variable-buffer-local 'prime-next-pattern)
;(defvar	prime-cands nil)
;(make-variable-buffer-local 'prime-cands)
; $BA02sF~NO;~$N%+!<%=%k0LCV(B. $B%3%s%F%-%9%H$NM-8z@-$rH=Dj(B
(defvar prime-marker nil);; nil $B$8$c$J$$$H(B local $B$K$J$i$J$$(B.
(make-variable-buffer-local 'prime-marker)
; $B%+!<%=%k<jA0$NJ8;zNs(B. $B%3%s%F%-%9%H$NM-8z@-$rH=Dj(B
(defvar prime-previous-substring "") 
(make-variable-buffer-local 'prime-previous-substring)
;(defvar prime-context nil) ; $B8!:w8uJd$N%3%s%F%-%9%H(B. $B<g$KA02sF~NOC18l(B
;(make-variable-buffer-local 'prime-context)
;(defvar	prime-nth-cand 0) ; $B$$$/$D$a$N8uJd$rA*Br$7$F$$$k$+(B
;(make-variable-buffer-local 'prime-nth-cand)
(defvar	prime-curstr-begin nil)
(make-variable-buffer-local 'prime-curstr-begin)
(defvar	prime-curstr-end nil)
(make-variable-buffer-local 'prime-curstr-end)
(defvar	prime-curstr "")		; $B%F%s%]%i%j$KA*Br(B/$BI=<($5$l$F$$$kJ8;zNs(B
(make-variable-buffer-local 'prime-curstr)
(defvar	prime-cand-list-begin nil)
(make-variable-buffer-local 'prime-cand-list-begin)
(defvar	prime-cand-list-end nil)
(make-variable-buffer-local 'prime-cand-list-end)
(defvar	prime-buffer-undo-list nil)
(make-variable-buffer-local 'prime-buffer-undo-list)
(defvar prime-cand-column 0)
(make-variable-buffer-local 'prime-cand-column)
(defvar prime-cand-column-list nil)
(make-variable-buffer-local 'prime-cand-column-list)
(defvar prime-cand-column-length 0)
(make-variable-buffer-local 'prime-cand-column-length)
(defvar prime-cand-position nil)
(make-variable-buffer-local 'prime-cand-position)
(defvar prime-narrow-cands nil)
(make-variable-buffer-local 'prime-narrow-cands)
(defvar prime-narrow-column 0)
(make-variable-buffer-local 'prime-narrow-column)
(defvar prime-narrow-orig-cands nil)
(make-variable-buffer-local 'prime-narrow-orig-cands)
(defvar prime-narrow-orig-nth-cand 0)
(make-variable-buffer-local 'prime-narrow-orig-nth-cand)
(defvar prime-modeline-original nil)
(make-variable-buffer-local 'prime-modeline-original)
(defvar prime-modeline-status "[PRIME]")
(make-variable-buffer-local 'prime-modeline-status)
(defvar prime-input-column 0)
(make-variable-buffer-local 'prime-input-column)
(defvar prime-tmp-fontify-region nil)
(make-variable-buffer-local 'prime-tmp-fontify-region)
(defvar prime-conv-exact-p nil "non nil $B$N>l9g(B, $BC14A;zJQ49%b!<%I(B")
(make-variable-buffer-local 'prime-conv-exact-p)
(defvar prime-learn-p t "$B3X=,$r9T$&$+$I$&$+(B ($BFbItMQ(B)")

(make-variable-buffer-local 'font-lock-fontify-region-function)

;; undefined $B%-!<$rO"B3$7$FC!$$$?2s?t(B. ($B%f!<%6$N%F%s%Q%jEY(B)
(defvar prime-undefined-count  0)
(make-variable-buffer-local 'prime-undefined-count)

(defvar prime-keymap-init-hook nil "$B%-!<%^%C%W@_Dj;~$N%U%C%/(B")
(defvar prime-mode-init-hook   nil "$B%b!<%I@_Dj;~$N%U%C%/(B")
(defvar prime-init-hook        nil "PRIME $B=i4|@_Dj;~$N%U%C%/(B")
(defvar prime-mode-hook        nil "PRIME $B%b!<%I@Z$jBX$(;~$N%U%C%/(B")

;; Emacs18$B$N>l9gI,MW(B
;; (defun member (e l)
;;   (if (null l) nil
;;     (if (equal e (car l)) l
;;       (member e (cdr l)))))

;;;; ------------------------------------------------------------
;;;; $B=i4|2=MQ4X?t(B
;;;; ------------------------------------------------------------
(defun prime-reset-pat ()
  (setq prime-pat-for-undo prime-pat)
  (setq prime-pat "")
  )

(defun prime-reset-cands ()
  (setq prime-cands-for-undo prime-context)
  (setq prime-cands nil)
  )

(defun prime-set-context (word)
  (setq prime-context-for-undo prime-context)
  (setq prime-context word)
  )

(defun prime-reset-context ()
  (setq prime-context-for-undo prime-context)
  (setq prime-context "")
  )

(defun prime-reset-nth-cand ()
  (setq prime-nth-cand-for-undo prime-nth-cand)
  (setq prime-nth-cand 0)
  )

;;;; ------------------------------------------------------------
;;;; undo $BMQ4X?t(B
;;;; ------------------------------------------------------------
(defun prime-undo ()
  (interactive)
  (cond
   (prime-fund-mode
    (prime-fund-undo))
   (prime-narrow-mode
    (if (= (length prime-narrow-pat) 1)
	(progn
	  (prime-narrow-mode-off)
	  (prime-disp-conv))
      (setq prime-narrow-pat (substring prime-narrow-pat 0 -1))
      (setq prime-narrow-column (1- prime-narrow-column))
      (prime-disp-narrow)))
   (prime-conv-mode
    (prime-conv-prev))
   (t
    (if (= (length prime-pat) 1)
	(prime-conv-cancel-all)
      (setq prime-pat (substring prime-pat 0 -1))
      (setq prime-input-column (1- prime-input-column))
      (prime-disp-input)
      ))))

;;;; ============================================================

;; $B8uJd0lMw$N0LCV>pJs$r7W;;(B
(defun prime-cand-set-column-list () ;; $B%3!<%I$,1x$M$((B!!!
  (let ((i 0)
	(col 0)
	(col-stop (window-width))
	list column-list)
    (while (< i (length prime-cands))
      (let ((length (+ (string-width (prime-nth-candidate i)) 2))) ; 2 = margin
	(and (> (+ col length 3) col-stop)
	     (progn
	       (setq list (cons (cons col nil) list))
	       (setq col col-stop)
	       (setq col-stop (+ col-stop (window-width)))
	       ))
	(setq list (cons (cons col i) list))
	(setq col (+ col length))
	(setq i (1+ i))
	))
    (setq list (cons (cons col-stop nil) (cons (cons col nil) list)))
    (setq prime-cand-column-list (reverse list))
    (setq prime-cand-column-length col-stop)
    ))

(defun prime-toggle-mode-line ()
  (cond ((not prime-mode)
	 (setq mode-line-format prime-modeline-original)
	 (setq prime-modeline-original nil))
	(t
	 (or prime-modeline-original
	     (setq prime-modeline-original mode-line-format))
	 (setq mode-line-format (cons prime-modeline-status
				      (cdr mode-line-format)))
	 ))
  ;; 2001/09/06 $B$3$l$rF~$l$J$$$H(B mode-line $BI=<($N99?7$,CY$l$k(B.
  (and (functionp 'force-mode-line-update)
       (force-mode-line-update))
  )

(defun prime-face-find-color (arg)
  (if (listp arg) ;; '(X TTY)
      (mell-color-find (nth 0 arg) (nth 1 arg))
    arg)
  )

(defun prime-set-cursor-color ()
  (let ((current-color (mell-color-find (mell-color-get-cursor) 7))
	(mode-color
	 (cond (prime-narrow-mode
		(prime-face-find-color prime-narrow-cursor-color))
	       ((and prime-cand-mode (featurep 'xemacs))
		;; Emacs $B$@$HM>7W$J5$$r;H$C$FGr?'$GI=<($7$F$7$^$&(B.
		(mell-color-get-background)) 
	       (prime-mode
		(prime-face-find-color prime-cursor-color))
	       (t
		prime-default-cursor-color))))
    ;; FIXME: Use input-method-activate-hook instead of post-command-hook.
    ;; FIXME: <komatsu@taiyaki.org> (2004-03-19)
    (if (and (not (eq current-color mode-color))
	     (or (null current-input-method)
		 (eq (nth 2 (assoc current-input-method input-method-alist))
		     'prime-mode)))
	(set-cursor-color mode-color))
    ))

(defun prime-reset-before-input ()
  (prime-reset-pat)
  (setq prime-prev-pattern nil) ; $B8!:w%Q%?%s(B
  (prime-reset-cands)
  (prime-reset-nth-cand)
  (mell-marker-set 'prime-curstr-begin (point))
  (mell-marker-set 'prime-curstr-end (point))
  (mell-marker-set 'prime-cand-list-begin (point))
  (mell-marker-set 'prime-cand-list-end (point))
  )

(defun prime-reset-after-fix ()
  (prime-reset-pat)
  (setq prime-start-pat "")
  (setq prime-prev-pattern nil) ; $B8!:w%Q%?%s(B
  (setq prime-input-column 0) ;; $B$3$3$G$b@_Dj$5$l$F$$$k$N$OIi$1(B.
  (prime-reset-cands)
  (prime-reset-nth-cand)
  (mell-marker-set 'prime-curstr-begin (point))
  (mell-marker-set 'prime-curstr-end (point))
  (setq prime-curstr "")	; $B%F%s%]%i%j$KA*Br(B/$BI=<($5$l$F$$$kJ8;zNs(B
  (mell-marker-set 'prime-cand-list-begin (point))
  (mell-marker-set 'prime-cand-list-end (point))
  (setq prime-conv-exact-p nil)
  (setq prime-conv-mode-for-undo prime-conv-mode)
  (setq prime-narrow-mode nil)
  (prime-narrow-mode-reset)
  (prime-enum-mode-reset)
  )

;; n$BHVL\$N8uJd$rF@$k!#:G=i$N8uJd$O(B0$BHVL\!#(B
(defun prime-nth-candidate (n)
  (let (s)
    (setq s (nth n prime-cands))
    (if (stringp s) s "")
    ))

(defun prime-disp-input (&optional pattern)
  (setq pattern (or pattern prime-pat))
  (prime-erase-curstr)
  (prime-disp-curstr)

  (when (sit-for 0.01)
    (prime-erase-cand-list)
    (prime-set-cands pattern)
    (and (> (length prime-cands) 0)
	 (prime-disp-cand-list)))
  )
  
(defun prime-disp-conv (&optional nth)
  (setq prime-nth-cand (or nth prime-nth-cand))
  (prime-erase-cand-list)
  (prime-erase-curstr)
  (prime-disp-curstr)
  (prime-disp-cand-list)
  )

(defun prime-disp-narrow (&optional nth)
  (setq prime-nth-cand (or nth prime-nth-cand))
  (setq prime-cands
	(if (string= prime-narrow-pat "")
	    prime-narrow-orig-cands
	  (delete nil (prime-narrow-compare-list
		       prime-narrow-orig-cands 
		       (prime-search prime-narrow-pat)))))
  (prime-cand-set-column-list)
  (prime-erase-cand-list)
  (prime-erase-curstr)
  (prime-disp-curstr)
  (and (> (length prime-cands) 0)
       (prime-disp-cand-list))
  )  

;; $B8uJd%j%9%HI=<($r>C$9(B
(defun prime-erase-cand-list ()
  (if (not (equal prime-cand-list-begin prime-cand-list-end))
      (delete-region (1- prime-cand-list-begin) prime-cand-list-end))
  (mell-marker-set 'prime-cand-list-begin (point))
  (mell-marker-set 'prime-cand-list-end   (point))
;  (setq prime-cand-list-begin (point))
;  (setq prime-cand-list-end (point))
  )

;; $BA*Br8uJd$r>C$9(B
(defun prime-erase-curstr ()
  (if (not (equal prime-curstr-begin prime-curstr-end))
      (delete-region prime-curstr-begin prime-curstr-end))
  (mell-marker-set 'prime-curstr-begin (point))
  (mell-marker-set 'prime-curstr-end   (point))
;  (setq prime-curstr-begin (point))
;  (setq prime-curstr-end (point))
  )

;; $BA*Br8uJd$rI=<((B
;; $B1x$/$J$C$F$-$?(B. narrow-mode $B$OJ,$1$h$&(B.
(defun prime-disp-curstr ()
  (setq prime-curstr
	(cond (prime-conv-mode
	       (prime-nth-candidate prime-nth-cand))
	      ;; prime-input-mode
	      ((and (= prime-input-column (length prime-pat))
		    (eq prime-language-default 'japanese))
	       (or (prime-input-get-label) prime-pat))
	      (t
	       prime-pat)))
  (mell-marker-set 'prime-curstr-begin (point))
  (if prime-narrow-mode
      (insert "[" prime-curstr "|" 
	      (prime-get-hiragana prime-pat) "*" ;; $B%-%?%M!<(B, $B;`$L!<(B.
	      (if (= prime-narrow-column (length prime-narrow-pat))
		  (prime-get-hiragana prime-narrow-pat)
		prime-narrow-pat)
	      "]")
    (insert "[" prime-curstr "]"))
  (mell-marker-set 'prime-curstr-end (point))

  (if prime-narrow-mode
      (and (/= prime-narrow-column (length prime-narrow-pat))
	   (backward-char (1+ (- (length prime-narrow-pat)
				 prime-narrow-column))))
    (and (not prime-conv-mode)
	 (/= prime-input-column (length prime-pat))
	 (backward-char (1+ (- (length prime-pat) prime-input-column))))
    )
  )

;; $B8uJd%j%9%H$r%+!<%=%k$N(B1$B9T2<$KI=<((B
(defun prime-disp-cand-list ()
  (save-excursion
    (cond
     ((or prime-disp-cand-list-oneline
	  ;; $B%+!<%=%k0LCV$K$h$C$F$O8uJd$,8+$($J$$$N$G(B, 1 $B9T$GI=<((B
	  (and (>= (1+ (count-lines (window-end nil t) (window-start))) 
		   (window-height))
	       (<= (count-lines (window-end nil t) (point)) 1)))
      (goto-char prime-curstr-end)
      ;; marker $B$H$N7s$M9g$$$G$A$g$C$HD>46E*$G$J$$$3$H$K$J$C$F$$$k(B.
      ;; marker $B$O(B (] $B$G$"$k(B.
      (insert " ")
      (mell-marker-set 'prime-cand-list-begin (point))
      (prime-disp-cand-list-one)
      )
     ((or prime-cand-mode); prime-conv-mode)
      (end-of-line)
      ;; marker $B$H$N7s$M9g$$$G$A$g$C$HD>46E*$G$J$$$3$H$K$J$C$F$$$k(B.
      (insert "\n")
      (mell-marker-set 'prime-cand-list-begin (point))
      ;;
      (prime-disp-cand-list-all)
      )
     (t
      (let (col)
	(goto-char prime-curstr-begin)
	(setq col (+ (% (current-column) (window-width))
		     (/ (current-column) (window-width))))
	(end-of-line)
	;; marker $B$H$N7s$M9g$$$G$A$g$C$HD>46E*$G$J$$$3$H$K$J$C$F$$$k(B.
	(insert "\n")
	(mell-marker-set 'prime-cand-list-begin (point))
	;;
	(insert (make-string col 32)) ; 32 = space
	(prime-disp-cand-list-one)
	)))
    ;; marker $B$H$N7s$M9g$$$G$A$g$C$HD>46E*$G$J$$$3$H$K$J$C$F$$$k(B.
    (mell-marker-set 'prime-cand-list-end (point))
    ;;
    ))

;; $B8uJd$rI=<((B (1 $B9T(B)
;(defun prime-disp-cand-list-one ()
;  (let ((i (+ prime-nth-cand (if prime-conv-mode 1 0))))
;    (while (and (< i (+ prime-nth-cand 10)) (nth i prime-cands))
;      (if (and prime-enum-mode (< i (length prime-enum-char-list)))
;	  (insert (char-to-string (nth i prime-enum-char-list))
;		  (prime-nth-candidate i) " ")
;	(insert "(" (prime-nth-candidate i) ")"))
;      (setq i (1+ i))
;      )))

(defun prime-disp-cand-list-one ()
  (let ((i 0)
	(offset (+ prime-nth-cand (if prime-conv-mode 1 0))))
    (while (and (< i 10) ;(if prime-conv-mode 10 3))
		(nth (+ i offset) prime-cands))
      (if (and prime-enum-mode 
	       (or prime-conv-mode (not prime-enum-mode-ignorep))
	       (< i (length prime-enum-char-list)))
	  (insert (char-to-string (nth i prime-enum-char-list))
		  (prime-nth-candidate (+ i offset)) " ")
	(insert "(" (prime-nth-candidate (+ i offset)) ")"))
      (setq i (1+ i))
      )
    ))


(defun prime-disp-cand-list-all ()
  (let ((i 0))
    (while (< i (length prime-cands))
      (and (> (+ (current-column) (string-width (prime-nth-candidate i)) 5)
	      (window-width))
	   (insert "\n"))
      (if (= i prime-nth-cand)
	  (let (beginning end)
	    (setq beginning (point))
	    (insert "[" (prime-nth-candidate i) "]")
	    (setq end (point))
	    (font-lock-prepend-text-property
	     beginning end 'face 'prime-cand-cursor-face)
; $B$3$l$O(B XEmacs only
;	    (font-lock-set-face beginning end 'prime-cand-cursor-face)
	    )
	(insert "(" (prime-nth-candidate i) ")"))
      (setq i (1+ i))
      )))

(defun prime-fontify-region (beg end &optional loudly)
  nil)

(defun prime-register (&optional word pattern)
  (interactive)
  (or word
      (if (mell-region-active-p)
	  (setq word (buffer-substring (region-beginning) (region-end)))
	(setq word (read-from-minibuffer "[$BC18lEPO?(B] $BC18l(B: "))))
  (or pattern
      (setq pattern (read-from-minibuffer 
		     (concat "[$BC18lEPO?(B] $B!V(B" word "$B!W$NFI$_(B: "))))
  (prime-server-dict-register-word word pattern)
  )

(defun prime-register-word (&optional pat)
  (interactive)
  (setq pat (or pat prime-pat))
  (let ((minibuffer-setup-hook (cons 'prime-mode-on minibuffer-setup-hook))
	(prime-learn-p nil)
	kana word)
    (setq pron (prime-input-get-label pat))
    (setq word (read-string (concat "[$BC18lEPO?(B] $B!V(B" pron "$B!W$NJQ49(B: ")))
    (prime-server-dict-register-word word pron)
    (prime-fix-without-learn word)
    (prime-fund-mode t)
    )
  )

(defun prime-get-nth (&optional word pattern)
  (if (not word)
      prime-nth-cand
    (or pattern (setq pattern prime-pat))
    (mell-list-member-get-nth word (prime-search pattern))
    ))

(defun prime-fix (cand) ; $B8uJd$r(Bcand$B$K3NDj(B
  (and (> (length cand) 0)
       (prime-server-select cand))
  (prime-fix-internal cand)
  )

(defun prime-fix-without-learn (cand)
  (prime-fix-internal cand))

(defun prime-fix-internal (word)
  (prime-erase-cand-list)
  (prime-erase-curstr)
  (and (> (length word) 0)
       (prime-insert word))
  (prime-reset-after-fix)
  (prime-conv-mode-off)
  )

(defun prime-after-fix (&optional next-char)
  (if next-char
      (if (= (length prime-next-pattern) 0)
	  (setq prime-next-pattern (char-to-string next-char))
	(if (not (string= (downcase (char-to-string next-char))
			  (substring prime-next-pattern 0 1)))
	    (setq prime-next-pattern (char-to-string next-char))
	  )))
  (if (or prime-predict-after-fix (> (length prime-next-pattern) 0))
      (progn
	(setq prime-pat prime-next-pattern)
	(setq prime-next-pattern "")
	(setq prime-input-column (length prime-pat))
	(prime-input-mode-on)
	(prime-disp-input))
    (prime-fund-mode-on)
    )
  )

(defun prime-insert (word)
  (let (undo-begin undo-end)
    (setq undo-begin (point))
    (insert word)
    (prime-set-context word) ;; $B$3$3$,E,@Z(B?
    (setq prime-previous-substring
	  (buffer-substring (max 1 (- (point) 5)) (point)))
    (set-marker prime-marker (point)) ;; $B$3$3$,E,@Z(B?
    (and auto-fill-function
	 (funcall auto-fill-function))
    (setq undo-end (point))
    (setq prime-buffer-undo-list 
	  (cons (cons undo-begin undo-end) (cons nil prime-buffer-undo-list)))
    ))

(defun prime-dict-word-delete ()
  (interactive)
  (if (y-or-n-p (concat prime-curstr " $B$r:o=|$7$^$9$+(B? "))
      (progn
	(prime-server-dict-delete-word prime-curstr prime-pat)
	(prime-conv-next))
    ))

(defun prime-undefined ()
  (interactive)
  (message (concat 
	    (key-description (this-command-keys)) " $B$ODj5A$5$l$F$$$^$;$s(B. ("
	    (key-description (car (where-is-internal 'prime-conv-cancel)))
	    " $B$,<h$j>C$7%-!<$G$9(B.)"))
  (beep)
  (if (eq last-command this-command)
      (and (> (setq prime-undefined-count (1+ prime-undefined-count)) 2)
	   (if (y-or-n-p "PRIME $B%b!<%I$r=*N;$7$^$9$+(B? ")
	       (prime-mode-off)
	     (message 
	      (concat (key-description (car (where-is-internal 'prime-mode)))
		      " $B$G(B PRIME $B%b!<%I$r=*N;2DG=$G$9(B."))
	     ))
    (setq prime-undefined-count 1))
  )


(defun prime-language-toggle ()
  (interactive)
  (let ((lang-list (member prime-language-default prime-language-list)))
    (setq prime-language-default
	  (or (nth 2 lang-list) (car prime-language-list)))
    (setq prime-modeline-status 
	  (or (nth 3 lang-list) (nth 1 prime-language-list)))
    )
  (prime-toggle-mode-line)
  (cond (prime-input-mode
	 (prime-disp-input))
	(prime-conv-mode
	 (prime-disp-conv)))
  )

(defun prime-conv-ascii ()
  (interactive)
  (prime-fix prime-pat)
  (prime-after-fix)
  (prime-fund-mode-on)
  )

(defun prime-conv-hiragana ()
  (interactive)
  (prime-fix (prime-get-hiragana prime-pat))
  (prime-after-fix)
  (prime-fund-mode-on)
  )

(defun prime-conv-hiragana-without-learn ()
  (interactive)
  (prime-fix-without-learn (prime-get-hiragana prime-pat))
  (prime-after-fix)
  (prime-fund-mode-on)
  )

(defun prime-conv-katakana ()
  (interactive)
  (prime-fix (prime-get-katakana prime-pat))
  (prime-after-fix)
  (prime-fund-mode-on)
  )

(defun prime-context-keep-p ()
  (or
   prime-input-mode prime-conv-mode
   (and (eq (marker-position prime-marker) (point))
	(string= (buffer-substring (max 1 (- (point) 5)) (point))
		 prime-previous-substring)))
  )
  

;; ----- prime-keyin $B4X78(B ----------
(defun prime-keyin-direct (char)
  ;; $BF~NOJ8;z$,(B prime-direct-keymap $B$KEPO?$5$l$F$$$k$J$i(B, $BB(3NDj(B.
  (let ((direct-pair (assoc char prime-direct-key-alist)))
    (if direct-pair
	(progn
	  (prime-fix prime-curstr)
	  (prime-after-fix)
	  (prime-insert (nth 1 direct-pair))
	  t)
      nil)))

(defun prime-input-all-capital-p (input)
  (let ((case-fold-search nil))
    (string-match "^[A-Z]+$" input)))

(defun prime-input-no-japanese-p (input)
  (string-match "\\cj+[a-zA-Z-]+\\cj+\\|^[a-zA-Z-]*$"
		(prime-get-hiragana input)))

(defun prime-keyin-capital (char)
  ;; $BBgJ8;z$J$I$,F~NO$5$l$+$D(B, $BFbMF$,BEEv$J$i$P3NDj(B.
  (if (and prime-fix-by-capital-p (>= char ?A) (<= char ?Z)
	   (not (prime-input-no-japanese-p prime-pat))
	   (not (prime-input-all-capital-p prime-pat))
	   )
      (progn
	(prime-fix prime-curstr)
	(prime-after-fix char)
	t)
    nil))

(defun prime-keyin-kutouten (char)
  (cond
   ((or (not prime-style-kutouten-direct-p)
	prime-enum-mode-ignorep)
    nil)
   ((eq char ?.)
    (prime-fix prime-curstr)
    (prime-after-fix)
    (if prime-style-kutouten-local
	(prime-insert (car prime-style-kutouten-local))
      (prime-insert (car prime-style-kutouten)))
    t)
   ((eq char ?,)
    (prime-fix prime-curstr)
    (prime-after-fix)
    (if prime-style-kutouten-local
	(prime-insert (cdr prime-style-kutouten-local))
      (prime-insert (cdr prime-style-kutouten)))
    t)
   (t nil)))

(defun prime-keyin (&optional char)
  (interactive)
  (setq char (or char last-input-char))
  (or (prime-context-keep-p) (setq prime-context nil))

  (cond
   ((prime-enum-keyin char))

   ((prime-keyin-kutouten char))

   ((prime-keyin-direct char))

   (prime-conv-mode
    (prime-fix prime-curstr)
    (prime-after-fix char)
    )

   ((prime-keyin-capital char))

   (t ;; prime-fund-mode
    (prime-input-mode-on)
    (prime-input-insert-char char)
    (prime-disp-input))
   ))

(defalias 'prime-cand-keyin 'prime-keyin)

;; $B%9%Z!<%9$rA^F~(B.
(defun prime-space () ;; prime-conv-space ?
  (interactive)
  (prime-fix prime-curstr)
  (prime-fund-mode-on)
  (insert " "))
;; prime-space $B$=$N(B 2
;  (if (> prime-nth-cand 0)
;      (progn
;	(prime-fix prime-curstr)
;	(prime-fund-mode)
;	(insert " "))
;    (setq prime-pat (concat prime-pat " "))
;    (prime-disp-input prime-pat)
;    ))

(provide 'prime-main)

