;;;; prime-suikyo.el: Wrapper of suikyo; romaji-hiragana conversion library. 
;;;; $Id: prime-suikyo.el,v 1.2 2004/01/27 08:17:23 komatsu Exp $
;;;;
;;;; Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
;;;;     All rights reserved.
;;;;     This is free software with ABSOLUTELY NO WARRANTY.
;;;;
;;;; You can redistribute it and/or modify it under the terms of 
;;;; the GNU General Public License version 2.

(require 'suikyo)

(defcustom prime-suikyo-capital-sensitive nil
  "$B%-!<%\!<%IF~NO;~$KBgJ8;z$H>.J8;z$r6hJL$9$k$+$I$&$+(B ($B$+$JF~NO;~$J$I$GMxMQ(B)")

(defvar prime-suikyo-table nil)
(defvar prime-suikyo-reverse-table nil)

(defun prime-suikyo-init (&optional forcep)
  (setq prime-suikyo-reverse-table
	(prime-suikyo-make-table-from-env "suikyo_reverse_tables"))
  (setq prime-suikyo-table (prime-suikyo-make-table-from-env "suikyo_tables"))
  )

(defun prime-suikyo-make-table-from-env (key)
  (prime-suikyo-make-table (prime-server-get-env key)))

(defun prime-suikyo-make-table (table-file-list)
  (let ((table (list nil)))
    (while table-file-list
      (setq table (suikyo-table-loadfile table (car table-file-list)))
      (setq table-file-list (cdr table-file-list))
    )
    table))

(defun prime-get-hiragana (&optional pattern)
  (or pattern (setq pattern prime-pat))
  (or prime-suikyo-capital-sensitive
      (setq pattern (downcase pattern)))
  (suikyo-convert prime-suikyo-table pattern))

(defun prime-get-katakana (&optional pattern)
  (or pattern (setq pattern prime-pat))
  (japanese-katakana (prime-get-hiragana pattern)))

(provide 'prime-suikyo)
