/***************************************************************************
                          analyzer.c  -  description
                             -------------------
    begin                : Thu Sep 19 2002
    copyright            : (C) 2002, 2004 by Jan Fernquist, Florian Boor
    email                : boor@unix-ag.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include "analyzer.h"
#include "prismstumbler.h"

typedef unsigned short u16;

char logbuf[120];
extern ScanResult_t Res;
int LOG_PACKETS = 0;
int FAKEAP_FILTER = 0;


inline int 
extract_subnet(unsigned char* adrinfo)
{
	if (adrinfo[0] == 0xFF) return FALSE;
	if (adrinfo[1] == 0xFF) { adrinfo[1]=0x00;adrinfo[2]=0x00;adrinfo[3]=0x00; return TRUE;}
	if (adrinfo[2] == 0xFF) { adrinfo[2]=0x00;adrinfo[3]=0x00; return TRUE;}
	if (adrinfo[3] == 0xFF) { adrinfo[3]=0x00; return TRUE;}
	return FALSE;		
}


void
send_node (nodeinfo_t *node, int sock)
{
	psmessage_t msg;
	msg.type = msg_node;
	msg.content.node = *node;
	if (write (sock, (void *) &msg, sizeof (psmessage_t)) < 0)
		perror ("err sending stream data");
}


int 
isResolved(const unsigned char *p) 
{
   unsigned char sum;
   if (p[1] == 255 && p[0] > 2 && p[0] < 16) return 1;
   sum = p[0] + p[1];
   if (sum == 1 && (p[2] <= 0x0A || p[2] == 0xFF)) return 1;
   if (sum <= 0x0C && (p[2] >= 0xF2 && p[2] <= 0xFE && p[2] != 0xFD)) return 1;
   return 0;
}


#if 0
/*
**************************************************************************
Function: ip_sum_calc
Description: Calculate the 16 bit IP sum.
***************************************************************************
*/
typedef unsigned short u16;
typedef unsigned long u32;

u16 ip_sum_calc(u16 len_ip_header, unsigned char buff[])
{
u16 word16;
u32 sum=0;
u16 i;
    
	// make 16 bit words out of every two adjacent 8 bit words in the packet
	// and add them up
	for (i=0;i<len_ip_header;i=i+2){
		word16 =((buff[i]<<8)&0xFF00)+(buff[i+1]&0xFF);
		sum = sum + (u32) word16;	
	}
	
	// take only 16 bits out of the 32 bit sum and add up the carries
	while (sum>>16)
	  sum = (sum & 0xFFFF)+(sum >> 16);

	// one's complement the result
	sum = ~sum;
	
return ((u16) sum);
}

/*
 * calculate IP header checksum (from Stevens, 1990)
 *
*/
int
in_cksum (u_short *ptr, int nbytes)
{
    long sum;
    u_short oddbyte;
    u_short answer;

    sum = 0;
    while (nbytes > 1) { 
     sum += *ptr++;
 nbytes -= 2;
    }
    if (nbytes == 1) {
     oddbyte = 0;
 *((u_char *) &oddbyte) = *(u_char *) ptr;
    }
    sum = (sum >> 16) + (sum & 0xffff);
    sum += (sum >> 16);
    answer = ~sum;
    return (answer);
}

#endif 

/* check ip header */

int 
check_ip_header(u16 *addr)
{
	u16 sum;
	u16 version;
	u16 chkhdr = addr[IP_OFFSET_CHKSUM_16];
	u16 count = (addr[IP_OFFSET_LENGTH_16] & IP_MASK_HDRLENGTH);

	if ((count >= 0x05) && (((addr[IP_OFFSET_LENGTH_16] & IP_MASK_VERSION) >> 4) == 4))
		return TRUE;

/*	addr[IP_OFFSET_CHKSUM_16] = 0x00;
	sum = ip_sum_calc(count,addr);
	sum2 = in_cksum(addr,count);
	printf("csh: %d csc %d, is: %d\n",chkhdr,sum,sum2);
	
	return (chkhdr == ~sum);
*/
	return FALSE;
}


   
/*
*
 * Get the different data from the MGMT header. Fill global struct
 */

int 
processPacket(unsigned char *packet, int len,int RealChannel, int ps_socket)
{
	FixedMgmt_t  *M;
	ProbeFixedMgmt_t  *P;
	AdmInfo_t    *A;
  	unsigned char *iv = NULL;
	unsigned char *admbits,*fixbits,*varBits;
	int tagType,tagLen;
	int i;
	static nodeinfo_t node;
	
	unsigned char *ip_src, *ip_dest;
	unsigned short *port_src, *port_dest;
	unsigned char *ip_load;

	memset(&node,0,sizeof(nodeinfo_t));
	
	admbits = packet;
	fixbits = &packet[sizeof(AdmInfo_t)]; /* This is where the payload starts*/

	A = (AdmInfo_t *) admbits; /* First the frame from the card */
	M =  (FixedMgmt_t *) fixbits; /*Then the actual data*/
	P =  (ProbeFixedMgmt_t *) fixbits; /*Then the actual data*/
	
	/* filter control packages */
	if (M->frametype & CTRL_PURE)
		return 0;

	memset(&Res,0,sizeof(Res));

	Res.FrameType = M->frametype;
	Res.protocol = IP_PROTO_NONE;
	if( M->frametype  == MGT_PROBE_RESP || M->frametype == MGT_BEACON ){
			Res.isAp   = IS_TO_DS(COOK_FLAGS(M->frametype)) != 0;
			Res.isAp   += IS_FROM_DS(COOK_FLAGS(M->frametype)) != 0; // in this case we have more than one ap
            Res.hasWep = IS_WEP(COOK_FLAGS(M->frametype)) != 0;
			Res.hasWep += IS_WEP_REQUIRED(M->Capabilities) != 0;
			Res.isAdHoc = IS_IBSS(M->Capabilities) != 0;
			Res.isAp += IS_ESS(M->Capabilities) != 0;
	}
	if( M->frametype  == MGT_PROBE || M->frametype == MGT_BEACON ){
			if(! ( M->DestAddr[0] == 0xff && M->DestAddr[1] == 0xff &&
				M->DestAddr[2] == 0xff && M->DestAddr[3] == 0xff &&
				M->DestAddr[4] == 0xff && M->DestAddr[5] == 0xff
			     ))  return 0;
	}

	if( M->frametype == MGT_PROBE  ){
		 Res.isAp   = AP_PROBE  ;
		 Res.hasWep =  0;
		 Res.Channel = RealChannel ;
	}

	Res.Signal = A->signal.data;
	Res.Noise = A->noise.data;
	if (M->frametype & DATA_PURE) /* do we have a data packet? */
	{
		int sdt = 0;
		int hdrlen = 0;
		Res.isData = 1;
		Res.Channel = RealChannel;
		Res.subnet[0]=0;
		Res.subnet[1]=0;
		Res.subnet[2]=0;

		// analyze packet
		sdt = (M->frametype & 0x0300) >> 8;
		switch(sdt)
		{
			case 0:  // node to node
				hdrlen = DATA_SHORT_HDR_LEN;
				sprintf(Res.DestMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->DestAddr[0], M->DestAddr[1],
					M->DestAddr[2], M->DestAddr[3],
					M->DestAddr[4], M->DestAddr[5]
			    );
				sprintf(Res.SrcMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->SrcAddr[0], M->SrcAddr[1],
				 	M->SrcAddr[2], M->SrcAddr[3],
				 	M->SrcAddr[4], M->SrcAddr[5]
			    );
				sprintf(Res.BssId,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->BssId[0], M->BssId[1],
				 	M->BssId[2], M->BssId[3],
				 	M->BssId[4], M->BssId[5]
				);
			break;

			case 2: // from node
				hdrlen = DATA_SHORT_HDR_LEN;
				sprintf(Res.DestMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->DestAddr[0], M->DestAddr[1],
					M->DestAddr[2], M->DestAddr[3],
					M->DestAddr[4], M->DestAddr[5]
				);
				sprintf(Res.BssId,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->SrcAddr[0], M->SrcAddr[1],
				 	M->SrcAddr[2], M->SrcAddr[3],
				 	M->SrcAddr[4], M->SrcAddr[5]
				);
				sprintf(Res.SrcMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->BssId[0], M->BssId[1],
				 	M->BssId[2], M->BssId[3],
				 	M->BssId[4], M->BssId[5]
				);
			break;
			case 1: // from ap
				hdrlen = DATA_SHORT_HDR_LEN;
				sprintf(Res.BssId,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->DestAddr[0], M->DestAddr[1],
					M->DestAddr[2], M->DestAddr[3],
					M->DestAddr[4], M->DestAddr[5]
				);
				sprintf(Res.SrcMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->SrcAddr[0], M->SrcAddr[1],
				 	M->SrcAddr[2], M->SrcAddr[3],
				 	M->SrcAddr[4], M->SrcAddr[5]
				);
				sprintf(Res.DestMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->BssId[0], M->BssId[1],
				 	M->BssId[2], M->BssId[3],
				 	M->BssId[4], M->BssId[5]
				);
			break;
			case 3: // ap to ap
				hdrlen = DATA_LONG_HDR_LEN;
				break;
				sprintf(Res.DestMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->DestAddr[0], M->DestAddr[1],
					M->DestAddr[2], M->DestAddr[3],
					M->DestAddr[4], M->DestAddr[5]
				);
				sprintf(Res.BssId,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->SrcAddr[0], M->SrcAddr[1],
				 	M->SrcAddr[2], M->SrcAddr[3],
				 	M->SrcAddr[4], M->SrcAddr[5]
				);
				sprintf(Res.SrcMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
					M->BssId[0], M->BssId[1],
				 	M->BssId[2], M->BssId[3],
				 	M->BssId[4], M->BssId[5]
				);

			//return 0; // we don't know the bssid
		} // case

		// a usable data packet?
		if (len > (hdrlen+10+g_offset))
		{
			iv = packet + hdrlen + g_offset ;
	        // What about WEP?
			if (((IS_WEP(COOK_FLAGS(M->frametype)) != 0)/* || (*((unsigned short *)iv) != 0xAAAA)*/))
			{
				// we have an encrypted packet with iv
			
				// check if ist is really usable
            	if (isResolved(iv)) {
					// do_something
					Res.hasIntIV = 1;
					sprintf(logbuf,"weak iv: %.2X:%.2X:%.2X:%.2X\n",iv[0],iv[1],iv[2],iv[3]);
					printf("%s",logbuf);
				}
			}
			else // looks like unencrypted traffic
			{
				iv += 8; /* set to start of ip payload */
				/* check if this is first fragment, is part 2 and 3 necessay? */
				if (check_ip_header( (u16 *) &iv[0] ) &&
				(!(iv[IP_OFFSET_FRAGMENT] & IP_MASK_FRAGMENT) && !iv[IP_OFFSET_FRAGMENT2]))
				{	
					Res.protocol = iv[IP_OFFSET_PROTO];
					if ((iv[IP_OFFSET_PROTO]) == IP_PROTO_TCP) {
							ip_src = iv+12;
							ip_dest = iv+16;
							ip_load = iv+20;//+ 4 * (*((unsigned short *)iv) & 0xF0); // length in byte, masq version
							port_src = (unsigned short *)ip_load;						
							port_dest = (unsigned short *)(ip_load+1);						
/*							if (((Res.SrcMac[0] == 0xFF) && 
								(Res.SrcMac[5] == 0xFF)) ||
								((Res.DestMac[0] == 0xFF) && 
								(Res.DestMac[5] == 0xFF)) &&
								(ip_dest[0] != 0xFF))
							{
*/							if(ip_dest[3] == 0xFF) {
								if (extract_subnet(ip_dest))
								{
	#ifdef DEBUG
									sprintf(logbuf,"net from tcp %i.%i.%i.%i \n",ip_dest[0],ip_dest[1],ip_dest[2],ip_dest[3]);
									printf("%s",logbuf);
	#endif								
									memcpy(Res.subnet,ip_dest,4);
								}
							}
//							if (LOG_PACKETS)
							{
								sprintf(node.bssid,Res.BssId);
								if (ntohs(port_src[0]) < 1024) node.port = ntohs(port_src[0]);
								else									
									if (ntohs(port_dest[0]) < 1024) node.port = ntohs(port_dest[0]);
								switch (sdt)
								{
									case 0:
									memcpy(&node.ip,ip_src,4);
									sprintf(node.mac,"%s",Res.SrcMac);	
									break;
									case 2:
									memcpy(&node.ip,ip_dest,4);
									sprintf(node.mac,"%s",Res.DestMac);	
									break;
									case 1:
									memcpy(&node.ip,ip_src,4);
									sprintf(node.mac,"%s",Res.SrcMac);	
									break;
									default:
									break;
								}
								send_node(&node,ps_socket);
/*								sprintf(logbuf,"TCP from %i.%i.%i.%i to %i.%i.%i.%i\n",ip_src[0],ip_src[1],ip_src[2],ip_src[3],ip_dest[0],ip_dest[1],ip_dest[2],ip_dest[3]);
								printf("%s",logbuf);
								sprintf(logbuf,"    port %i             %i\n",ntohs(port_src[0]),ntohs(port_dest[0]));		
								printf("%s",logbuf);
*/							}
	/*						p1 = port_src[0];  p2 = port_dest[0];
							service_i1 = getservbyport(htons(p1),"tcp");
							service_i2 = getservbyport(htons(p2),"tcp");
							if (service_i1) printf("serv1: %s\n",service_i1->s_name);		
							if (service_i2) printf("serv2: %s\n",service_i2->s_name);		
	*/				}
	
					if ((iv[IP_OFFSET_PROTO]) == IP_PROTO_UDP) {
				
							ip_src = iv+12;
							ip_dest = iv+16;
							ip_load = iv+20;// + 4 * (*((unsigned short *)iv) & 0xF0); // length in byte, masq version
							port_src = (unsigned short *)ip_load;						
							port_dest = (unsigned short *)(ip_load+1);						
	
/*							if (((Res.SrcMac[0] == 0xFF) && 
								(Res.SrcMac[5] == 0xFF)) ||
								((Res.DestMac[0] == 0xFF) && 
								(Res.DestMac[5] == 0xFF)) &&
								(ip_dest[0] != 0xFF))
							{
*/							if(ip_dest[3] == 0xFF) {
								if (extract_subnet(ip_dest))
								{
									memcpy(Res.subnet,ip_dest,4);
	#ifdef DEBUG
									sprintf(logbuf,"net from udp %i.%i.%i.%i \n",Res.subnet[0],Res.subnet[1],Res.subnet[2],Res.subnet[3]);
									printf("%s",logbuf);
	#endif
								}
								/* check for dhcp broadcast */
								if ((ip_dest[0] == 0xFF) && (ip_dest[1] == 0xFF) && (ip_dest[0] == 0xFF) && ntohs(port_dest[0]) == 68)
									Res.dhcp = 1;
							}
	
							//if (LOG_PACKETS)
							{
								sprintf(node.bssid,Res.BssId);
								if (ntohs(port_src[0]) < 1024) node.port = ntohs(port_src[0]);
								else									
									if (ntohs(port_dest[0]) < 1024) node.port = ntohs(port_dest[0]);
								switch (sdt)
								{
									case 0:
									memcpy(&node.ip,ip_src,4);
									sprintf(node.mac,"%s",Res.SrcMac);	
									break;
									case 2:
									memcpy(&node.ip,ip_dest,4);
									sprintf(node.mac,"%s",Res.DestMac);	
									break;
									case 1:
									memcpy(&node.ip,ip_src,4);
									sprintf(node.mac,"%s",Res.SrcMac);	
									break;
									default:
									break;
								}
								send_node(&node,ps_socket);
/*								sprintf(logbuf,"UDP from %i.%i.%i.%i to %i.%i.%i.%i\n",ip_src[0],ip_src[1],ip_src[2],ip_src[3],ip_dest[0],ip_dest[1],ip_dest[2],ip_dest[3]);
								printf("%s",logbuf);
	
								sprintf(logbuf,"    port %i             %i\n",ntohs(port_src[0]),ntohs(port_dest[0]));		
								printf("%s",logbuf);
*/							}
	/*						p1 = port_src[0];  p2 = port_dest[0];
							service_i1 = getservbyport(htons(p1),"udp");
							service_i2 = getservbyport(htons(p2),"udp");
							if (service_i1) printf("serv1: %s\n",service_i1->s_name);		
							if (service_i2) printf("serv2: %s\n",service_i2->s_name);		
	*/				}
	
					if ((iv[IP_OFFSET_PROTO]) == IP_PROTO_ICMP) 
					{
						
					}
	
					// dhcp check taken from kismet
					if (memcmp(&iv[DHCPD_OFFSET], DHCPD_SIGNATURE,sizeof(DHCPD_SIGNATURE)) == 0)
					{
						Res.dhcp = 1;
					}
				}	/* first fragment */	
			} /* unencrypted */
		} /* if len */
		Res.BssId[18] = 0;
		return 1;
	} //if
    else // handle beacon....
	{
		sprintf(Res.DestMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
		M->DestAddr[0], M->DestAddr[1],
		 M->DestAddr[2], M->DestAddr[3],
		 M->DestAddr[4], M->DestAddr[5]
		);
		sprintf(Res.SrcMac,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
			M->SrcAddr[0], M->SrcAddr[1],
		 	M->SrcAddr[2], M->SrcAddr[3],
			M->SrcAddr[4], M->SrcAddr[5]
		);

		sprintf(Res.BssId,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
			M->BssId[0], M->BssId[1],
		 	M->BssId[2], M->BssId[3],
		 	M->BssId[4], M->BssId[5]
		);
	} // handle packet types...
	if(  M->frametype == MGT_PROBE ){
		if( len <= sizeof(ProbeFixedMgmt_t) ) return 0;

		varBits = &fixbits[sizeof(ProbeFixedMgmt_t)];

	}else{ /* Beacon and Probe Response */
		if( len <= sizeof(FixedMgmt_t) ) return 0;

		varBits = &fixbits[sizeof(FixedMgmt_t)];
	}

	/* Get the tagged values
	 * There is a type and a length field
	 * Followed by tha actual data
         */
	while( varBits < (packet+len)){

		tagType = varBits[0];
		tagLen = varBits[1];
		varBits+=2;
	
		switch(tagType){
			case TAG_SSID:
					strncpy(Res.SSID,varBits,
				    tagLen > sizeof(Res.SSID)?
					sizeof(Res.SSID)-1:tagLen);
					break;

			case TAG_DS_PARAMETER:
						if(tagLen == 1){
							Res.Channel = *varBits;
						}
						break;
			/* we search for the max data rate */
			case TAG_SUPP_RATES:
				for (i=2;i<tagLen+2;i++)
					if ((((uint8_t)varBits[i] & 0x7F) * 500) > Res.speed)
						Res.speed = ((uint8_t)varBits[i] & 0x7F) * 500;	
				break;
			/* only accesspoints send TIM tags */
			case TAG_TIM:
				Res.isAdHoc = FALSE;
				Res.isAp = TRUE;
				break;
			/* only stations in IBSS mode send these */
			case TAG_IBSS_PARAMETER:
				Res.isAdHoc = TRUE;
				Res.isAp = FALSE;
				break;
			/* Skip all other values for the moment */
			case TAG_FH_PARAMETER:
			case TAG_CF_PARAMETER:
			case TAG_CHALLENGE_TEXT:	
						 break;
		}	
		varBits+=tagLen;
	}
	Res.BssId[18] = 0;
	return 1;
}
