/*
  libreiserfs - a library for manipulating reiserfs partitions
  Copyright (C) 2001-2004 Yury Umanets <torque@ukrpost.net>.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.
                                                                                                 
  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.
                                                                                                 
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
  Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>

#include <reiserfs/reiserfs.h>

#if ENABLE_NLS
# include <libintl.h>
# define _(String) dgettext (PACKAGE, String)
#else
# define _(String) (String)
#endif

int libreiserfs_get_max_interface_version(void) {
	return LIBREISERFS_MAX_INTERFACE_VERSION;
}

int libreiserfs_get_min_interface_version(void) {
	return LIBREISERFS_MIN_INTERFACE_VERSION;
}

const char *libreiserfs_get_version(void) {
	return VERSION;
}

static void _init(void) __attribute__ ((constructor));

static void _init(void) {
#ifdef ENABLE_NLS
	bindtextdomain(PACKAGE, LOCALEDIR);
#endif
}

void *libreiserfs_malloc(size_t size) {
	void *mem;

	if (!(mem = (void *)malloc(size))) {
		libreiserfs_exception_throw(EXCEPTION_FATAL,
					    EXCEPTION_CANCEL,
					    _("Out of memory."));
		return NULL;
	}

	return mem;
}

void *libreiserfs_calloc(size_t size, char c) {
	void *mem;

	if (!(mem = libreiserfs_malloc(size)))
		return NULL;
	memset(mem, c, size);

	return mem;
}

int libreiserfs_realloc(void** old, size_t size) {
	void *mem;

	if (!(mem = (void *)realloc(*old, size))) {
		libreiserfs_exception_throw(EXCEPTION_FATAL,
					    EXCEPTION_CANCEL,
					    _("Out of memory."));
		return 0;
	}
	*old = mem;
	return 1;
}

void libreiserfs_free(void* ptr) {
	free(ptr);
}
