/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeInfoVisitor;

public class LocalVariableTypeTableAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 2;
    public int u2localVariableTypeTableLength;
    public LocalVariableTypeInfo[] localVariableTypeTable;

    protected LocalVariableTypeTableAttrInfo() {
    }

    protected LocalVariableTypeInfo[] getLocalVariableTypeTable() throws Exception {
        return this.localVariableTypeTable;
    }

    protected int getLength() {
        return 2 + this.u2localVariableTypeTableLength * 10;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2localVariableTypeTableLength = dataInput.readUnsignedShort();
        this.localVariableTypeTable = new LocalVariableTypeInfo[this.u2localVariableTypeTableLength];
        for (int i = 0; i < this.u2localVariableTypeTableLength; ++i) {
            this.localVariableTypeTable[i] = LocalVariableTypeInfo.create(dataInput);
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2localVariableTypeTableLength);
        for (int i = 0; i < this.u2localVariableTypeTableLength; ++i) {
            this.localVariableTypeTable[i].write(dataOutput);
        }
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, AttrInfoVisitor attrInfoVisitor) {
        attrInfoVisitor.visitLocalVariableTypeTableAttrInfo(classFile, methodInfo, codeAttrInfo, this);
    }

    public void localVariablesAccept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfoVisitor localVariableTypeInfoVisitor) {
        for (int i = 0; i < this.u2localVariableTypeTableLength; ++i) {
            localVariableTypeInfoVisitor.visitLocalVariableTypeInfo(classFile, methodInfo, codeAttrInfo, this.localVariableTypeTable[i]);
        }
    }
}

