/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.CpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.obfuscate.Utf8UsageMarker;

public class Utf8Shrinker
implements ClassFileVisitor {
    private int[] cpIndexMap;
    private ConstantPoolRemapper constantPoolRemapper;

    public Utf8Shrinker(int n) {
        this.constantPoolRemapper = new ConstantPoolRemapper(n);
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.u2constantPoolCount = this.shrinkConstantPool(programClassFile.constantPool, programClassFile.u2constantPoolCount);
        this.constantPoolRemapper.setCpIndexMap(this.cpIndexMap);
        this.constantPoolRemapper.visitProgramClassFile(programClassFile);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    private int shrinkConstantPool(CpInfo[] cpInfoArray, int n) {
        int n2;
        if (this.cpIndexMap == null || this.cpIndexMap.length < n) {
            this.cpIndexMap = new int[n];
        }
        int n3 = 1;
        boolean bl = false;
        for (n2 = 1; n2 < n; ++n2) {
            this.cpIndexMap[n2] = n3;
            CpInfo cpInfo = cpInfoArray[n2];
            if (cpInfo != null) {
                boolean bl2 = bl = cpInfo.getTag() != 1 || Utf8UsageMarker.isUsed(cpInfo);
            }
            if (!bl) continue;
            cpInfoArray[n3++] = cpInfo;
        }
        for (n2 = n3; n2 < n; ++n2) {
            cpInfoArray[n2] = null;
        }
        return n3;
    }
}

