/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import proguard.obfuscate.MappingProcessor;
import proguard.retrace.StackTraceItem;

class StackTrace
implements MappingProcessor {
    private boolean verbose;
    private List stackTraceItems = new ArrayList();

    public StackTrace(boolean bl) {
        this.verbose = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(File file) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            try {
                Reader reader = file == null ? new InputStreamReader(System.in) : new BufferedReader(new FileReader(file));
                bufferedReader = new LineNumberReader(reader);
                while (true) {
                    String string;
                    if ((string = ((LineNumberReader)bufferedReader).readLine()) == null) {
                        Object var7_7 = null;
                        if (file == null) return;
                        if (bufferedReader == null) return;
                        break;
                    }
                    if ((string = string.trim()).length() == 0) continue;
                    StackTraceItem stackTraceItem = new StackTraceItem(this.verbose);
                    stackTraceItem.parse(string);
                    this.stackTraceItems.add(stackTraceItem);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't read stack trace (" + iOException.getMessage() + ")");
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (file == null) throw throwable;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return;
    }

    public void print() {
        for (int i = 0; i < this.stackTraceItems.size(); ++i) {
            StackTraceItem stackTraceItem = (StackTraceItem)this.stackTraceItems.get(i);
            stackTraceItem.print();
        }
    }

    public boolean processClassFileMapping(String string, String string2) {
        boolean bl = false;
        for (int i = 0; i < this.stackTraceItems.size(); ++i) {
            StackTraceItem stackTraceItem = (StackTraceItem)this.stackTraceItems.get(i);
            bl |= stackTraceItem.processClassFileMapping(string, string2);
        }
        return bl;
    }

    public void processFieldMapping(String string, String string2, String string3, String string4) {
    }

    public void processMethodMapping(String string, int n, int n2, String string2, String string3, String string4) {
        for (int i = 0; i < this.stackTraceItems.size(); ++i) {
            StackTraceItem stackTraceItem = (StackTraceItem)this.stackTraceItems.get(i);
            stackTraceItem.processMethodMapping(string, n, n2, string2, string3, string4);
        }
    }
}

