/******************************************************************************
* Copyright (C) 2008 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.20                                                         *
******************************************************************************/

#include <iostream>
#include <sstream>

#include "CPfMatchesDAOSQLite.h"

CPfMatchesDAOSQLite::CPfMatchesDAOSQLite(sqlite3 *database)
  : CPfMatchesDAOSQLiteEntity(database)
{
}

CPfMatchesDAOSQLite::~CPfMatchesDAOSQLite()
{
}

std::vector<CPfMatches*>* CPfMatchesDAOSQLite::findByXFkCompetitionAndXFkSeason(int XFkCompetition, int XFkSeason)
{
    std::ostringstream strXFkCompetition;
    strXFkCompetition << XFkCompetition;

    std::ostringstream strXFkSeason;
    strXFkSeason << XFkSeason;

    return findByXFkCompetitionAndXFkSeason(strXFkCompetition.str(), strXFkSeason.str());
}

std::vector<CPfMatches*>*  CPfMatchesDAOSQLite::findByXFkCompetitionAndXFkSeason(const std::string &XFkCompetition, const std::string &XFkSeason)
{
	std::string sql(
			"SELECT M.* "
			"FROM PF_MATCHES M "
			"  JOIN PF_COMPETITION_PHASES CP ON CP.X_COMPETITION_PHASE=M.X_FK_COMPETITION_PHASE ");
	sql +=	"WHERE CP.X_FK_COMPETITION='"+XFkCompetition+"' AND M.X_FK_SEASON='"+XFkSeason+"'";
	return loadVector(sql);
}

std::vector<CPfMatches*>* CPfMatchesDAOSQLite::findByXFkCompetitionPhaseAndXFkSeason(int XFkCompetitionPhase, int XFkSeason)
{
    std::ostringstream stream;
    stream << XFkCompetitionPhase;

    std::ostringstream strXFkSeason;
    strXFkSeason << XFkSeason;

    return findByXFkCompetitionPhaseAndXFkSeason(stream.str(), strXFkSeason.str());
}

std::vector<CPfMatches*>* CPfMatchesDAOSQLite::findByXFkCompetitionPhaseAndXFkSeason(const std::string &XFkCompetitionPhase, const std::string &XFkSeason)
{
    std::string sql("SELECT * FROM PF_MATCHES WHERE ");
    sql += "X_FK_COMPETITION_PHASE='"+XFkCompetitionPhase+"' AND X_FK_SEASON='"+XFkSeason+"'";
    return loadVector(sql);
}

CPfMatches* CPfMatchesDAOSQLite::findByXFkTeamHome(int XFkTeamHome)
{
    std::ostringstream stream;
    stream << XFkTeamHome;
    return findByXFkTeamHome(stream.str());
}

CPfMatches* CPfMatchesDAOSQLite::findByXFkTeamHome(const std::string &XFkTeamHome)
{
    std::string sql("SELECT * FROM PF_MATCHES WHERE ");
    sql += "X_FK_TEAM_HOME='"+XFkTeamHome+"'";
    return loadRegister(sql);
}

CPfMatches* CPfMatchesDAOSQLite::findByXMatch(int XMatch)
{
    std::ostringstream stream;
    stream << XMatch;
    return findByXMatch(stream.str());
}

CPfMatches* CPfMatchesDAOSQLite::findByXMatch(const std::string &XMatch)
{
    std::string sql("SELECT * FROM PF_MATCHES WHERE ");
    sql += "X_MATCH='"+XMatch+"'";
    return loadRegister(sql);
}

CPfMatches* CPfMatchesDAOSQLite::findByXFkTeamAway(int XFkTeamAway)
{
    std::ostringstream stream;
    stream << XFkTeamAway;
    return findByXFkTeamAway(stream.str());
}

CPfMatches* CPfMatchesDAOSQLite::findByXFkTeamAway(const std::string &XFkTeamAway)
{
    std::string sql("SELECT * FROM PF_MATCHES WHERE ");
    sql += "X_FK_TEAM_AWAY='"+XFkTeamAway+"'";
    return loadRegister(sql);
}

std::vector<CPfMatches*>* CPfMatchesDAOSQLite::findMatches()
{
    std::string sql("SELECT * FROM PF_MATCHES ORDER BY D_MATCH");
    return loadVector(sql);
}

std::vector<CPfMatches*>* CPfMatchesDAOSQLite::findMatchesNotPlayed()
{
    std::string sql("SELECT * FROM PF_MATCHES WHERE L_PLAYED='N' ORDER BY D_MATCH");
    return loadVector(sql);
}

CPfMatches* CPfMatchesDAOSQLite::findLastTeamMatch(int XTeam)
{
    std::ostringstream stream;
    stream << XTeam;
    return findLastTeamMatch(stream.str());
}

CPfMatches* CPfMatchesDAOSQLite::findLastTeamMatch(const std::string &XTeam)
{
    std::string sql("SELECT * FROM PF_MATCHES WHERE L_PLAYED='Y'");
    sql = sql + "AND (X_FK_TEAM_HOME='"+XTeam+"' OR X_FK_TEAM_AWAY='"+XTeam+"') ORDER BY D_MATCH DESC";
    return loadRegister(sql);
}

std::vector<CPfMatches*>* CPfMatchesDAOSQLite::findMatchesNotPlayedByXTeam(int XTeam)
{
    std::ostringstream stream;
    stream << XTeam;
    return findMatchesNotPlayedByXTeam(stream.str());
}

std::vector<CPfMatches*>* CPfMatchesDAOSQLite::findMatchesNotPlayedByXTeam(const std::string &XTeam)
{
    std::string sql("SELECT * FROM PF_MATCHES WHERE L_PLAYED='N'");
    sql = sql + "AND (X_FK_TEAM_HOME='"+XTeam+"' OR X_FK_TEAM_AWAY='"+XTeam+"') ORDER BY D_MATCH";
    return loadVector(sql);
}

