/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfCountriesDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfCountriesDAOSQLiteEntity::CPfCountriesDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfCountriesDAOSQLiteEntity::~CPfCountriesDAOSQLiteEntity()
{
}

void CPfCountriesDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfCountriesDAOSQLiteEntity::deleteReg(CPfCountries *reg)
{
    std::string sql("DELETE FROM PF_COUNTRIES WHERE X_COUNTRY=");
    sql += "'"+reg->getXCountry_str()+"'";
    return exec(sql);
}

bool CPfCountriesDAOSQLiteEntity::insertReg(CPfCountries *reg)
{
    std::string sql("INSERT INTO PF_COUNTRIES (X_FK_CONFEDERATION,S_FLAG,S_CAPITAL,S_COUNTRY,S_SHORT_NAME) VALUES (");
    sql += (reg->getXFkConfederation_str()=="")?"NULL":"'"+reg->getXFkConfederation_str()+"'";
    sql += (reg->getSFlag_str()=="")?",NULL":",'"+reg->getSFlag_str()+"'";
    sql += (reg->getSCapital_str()=="")?",NULL":",'"+reg->getSCapital_str()+"'";
    sql += (reg->getSCountry_str()=="")?",NULL":",'"+reg->getSCountry_str()+"'";
    sql += (reg->getSShortName_str()=="")?",NULL":",'"+reg->getSShortName_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXCountry(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfCountriesDAOSQLiteEntity::updateReg(CPfCountries *reg)
{
    std::string sql("UPDATE PF_COUNTRIES SET ");
    sql += (reg->getXFkConfederation_str()=="")?" X_FK_CONFEDERATION=NULL":" X_FK_CONFEDERATION='"+reg->getXFkConfederation_str()+"'";
    sql += (reg->getSFlag_str()=="")?",S_FLAG=NULL":",S_FLAG='"+reg->getSFlag_str()+"'";
    sql += (reg->getSCapital_str()=="")?",S_CAPITAL=NULL":",S_CAPITAL='"+reg->getSCapital_str()+"'";
    sql += (reg->getSCountry_str()=="")?",S_COUNTRY=NULL":",S_COUNTRY='"+reg->getSCountry_str()+"'";
    sql += (reg->getXCountry_str()=="")?",X_COUNTRY=NULL":",X_COUNTRY='"+reg->getXCountry_str()+"'";
    sql += (reg->getSShortName_str()=="")?",S_SHORT_NAME=NULL":",S_SHORT_NAME='"+reg->getSShortName_str()+"'";
    sql += " WHERE X_COUNTRY='"+reg->getXCountry_str()+"'";
    return exec(sql);
}

void CPfCountriesDAOSQLiteEntity::freeVector(std::vector<CPfCountries*>* vector )
{
    std::vector<CPfCountries*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfCountries* CPfCountriesDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfCountries *destiny = new CPfCountries();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfCountries*> * CPfCountriesDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfCountries*> *container = new std::vector<CPfCountries*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfCountriesDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfCountriesDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfCountries *destiny = (CPfCountries*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_CONFEDERATION")==0 ){
                destiny->setXFkConfederation_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_FLAG")==0 ){
                destiny->setSFlag_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_CAPITAL")==0 ){
                destiny->setSCapital_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_COUNTRY")==0 ){
                destiny->setSCountry_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_COUNTRY")==0 ){
                destiny->setXCountry_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_SHORT_NAME")==0 ){
                destiny->setSShortName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfCountriesDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfCountries*> *container = (std::vector<CPfCountries*> *)object;
        CPfCountries *destiny = new CPfCountries();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_CONFEDERATION")==0 ){
                destiny->setXFkConfederation_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_FLAG")==0 ){
                destiny->setSFlag_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_CAPITAL")==0 ){
                destiny->setSCapital_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_COUNTRY")==0 ){
                destiny->setSCountry_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_COUNTRY")==0 ){
                destiny->setXCountry_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_SHORT_NAME")==0 ){
                destiny->setSShortName_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

