/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfTeamsByCompetitionsDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfTeamsByCompetitionsDAOSQLiteEntity::CPfTeamsByCompetitionsDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfTeamsByCompetitionsDAOSQLiteEntity::~CPfTeamsByCompetitionsDAOSQLiteEntity()
{
}

void CPfTeamsByCompetitionsDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfTeamsByCompetitionsDAOSQLiteEntity::deleteReg(CPfTeamsByCompetitions *reg)
{
    std::string sql("DELETE FROM PF_TEAMS_BY_COMPETITIONS WHERE X_TEAM_BY_COMPETITION=");
    sql += "'"+reg->getXTeamByCompetition_str()+"'";
    return exec(sql);
}

bool CPfTeamsByCompetitionsDAOSQLiteEntity::insertReg(CPfTeamsByCompetitions *reg)
{
    std::string sql("INSERT INTO PF_TEAMS_BY_COMPETITIONS (X_FK_COMPETITION_BY_SEASON,X_FK_TEAM) VALUES (");
    sql += (reg->getXFkCompetitionBySeason_str()=="")?"NULL":"'"+reg->getXFkCompetitionBySeason_str()+"'";
    sql += (reg->getXFkTeam_str()=="")?",NULL":",'"+reg->getXFkTeam_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXTeamByCompetition(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfTeamsByCompetitionsDAOSQLiteEntity::updateReg(CPfTeamsByCompetitions *reg)
{
    std::string sql("UPDATE PF_TEAMS_BY_COMPETITIONS SET ");
    sql += (reg->getXFkCompetitionBySeason_str()=="")?" X_FK_COMPETITION_BY_SEASON=NULL":" X_FK_COMPETITION_BY_SEASON='"+reg->getXFkCompetitionBySeason_str()+"'";
    sql += (reg->getXTeamByCompetition_str()=="")?",X_TEAM_BY_COMPETITION=NULL":",X_TEAM_BY_COMPETITION='"+reg->getXTeamByCompetition_str()+"'";
    sql += (reg->getXFkTeam_str()=="")?",X_FK_TEAM=NULL":",X_FK_TEAM='"+reg->getXFkTeam_str()+"'";
    sql += " WHERE X_TEAM_BY_COMPETITION='"+reg->getXTeamByCompetition_str()+"'";
    return exec(sql);
}

void CPfTeamsByCompetitionsDAOSQLiteEntity::freeVector(std::vector<CPfTeamsByCompetitions*>* vector )
{
    std::vector<CPfTeamsByCompetitions*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfTeamsByCompetitions* CPfTeamsByCompetitionsDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfTeamsByCompetitions *destiny = new CPfTeamsByCompetitions();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfTeamsByCompetitions*> * CPfTeamsByCompetitionsDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfTeamsByCompetitions*> *container = new std::vector<CPfTeamsByCompetitions*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfTeamsByCompetitionsDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfTeamsByCompetitionsDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfTeamsByCompetitions *destiny = (CPfTeamsByCompetitions*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_COMPETITION_BY_SEASON")==0 ){
                destiny->setXFkCompetitionBySeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_TEAM_BY_COMPETITION")==0 ){
                destiny->setXTeamByCompetition_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_TEAM")==0 ){
                destiny->setXFkTeam_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfTeamsByCompetitionsDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfTeamsByCompetitions*> *container = (std::vector<CPfTeamsByCompetitions*> *)object;
        CPfTeamsByCompetitions *destiny = new CPfTeamsByCompetitions();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_COMPETITION_BY_SEASON")==0 ){
                destiny->setXFkCompetitionBySeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_TEAM_BY_COMPETITION")==0 ){
                destiny->setXTeamByCompetition_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_TEAM")==0 ){
                destiny->setXFkTeam_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

