/*
    DebuggerLoader.h

    Interface declaration of the DebuggerLoader class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class NSDictionary, NSArray, NSString;

@class ProjectDocument;
@protocol Debugger;

@interface DebuggerLoader : NSObject
{
  /* A dictionary where keys are debugger type IDs and values
   * are classes which handle them. */
  NSDictionary * debuggerTypes;
}

/// Returns a shared instance of a DebuggerLoader.
+ shared;

/**
 * Returns the a dictionary where keys are debugger types and values are
 * classes which implement the respective debugger.
 */
- (NSDictionary *) debuggerTypes;

/**
 * Initializes a debugger of type `debuggerTypeID' for `project'.
 */
- (id <Debugger>) debuggerForTypeID: (NSString *) debuggerTypeID
                            project: (ProjectDocument *) project;

@end
