/*
    FileManager.h

    Interface declaration of the FileManager class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "InternalProjectModule.h"

@class NSBrowser, NSMatrix, NSNotification;

/*
 * The pasteboard type used when dragging project files. The data
 * of the pasteboard is a property list of the form:
 * {
 *   Category = source-category;
 *   Project = project-file;     <- used to distinguish dragged files
 *                                  within projects and from one project
 *                                  to another project
 *   Contents = (
 *     <list-of-filenames>
 *   );
 * }
 */
extern NSString * const ProjectFilesPboardType;

@protocol NSDraggingInfo;

@interface FileManager : InternalProjectModule
{
  id browser;
  id fileIcon;
  id fileName;
  id filePath;
  id fileSize;
  id fileType;
  id lastModified;
}

- (void) openFile: (id)sender;

- (void)      browser: (NSBrowser *) sender
  createRowsForColumn: (int) column
             inMatrix: (NSMatrix *) matrix;
- (NSString *) browser: (NSBrowser *)sender titleOfColumn: (int)column;

- (void) selectFile: sender;
- (void) changeName: sender;

- (void) selectAndEditNameAtPath: (NSString *) aPath;

- (NSArray *) selectedFiles;
- (NSArray *) selectedCategories;
- (NSString *) containingCategory;

- (void) filesChanged: (NSNotification *) notif;

- (BOOL) performDragOperation: (id <NSDraggingInfo>) sender;

@end
